/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.model;

import com.dbeaver.ee.vqb.ui.VQBIcon;
import net.sf.jsqlparser.statement.select.Join;
import org.jkiss.dbeaver.model.DBIcon;

public enum VQBJoinType {
    SIMPLE("Simple", VQBIcon.JOIN_INNER, true),
    INNER("Inner", VQBIcon.JOIN_INNER, true),
    LEFT("Left", VQBIcon.JOIN_LEFT, true),
    RIGHT("Right", VQBIcon.JOIN_RIGHT, true),
    LEFT_EX("Left (if NULL)", VQBIcon.JOIN_LEFT_EX, false),
    RIGHT_EX("Right (if NULL)", VQBIcon.JOIN_RIGHT_EX, false),
    FULL_OUTER("Full", VQBIcon.JOIN_FULL_OUTER, true),
    FULL_OUTER_EX("Full (if NULL)", VQBIcon.JOIN_FULL_OUTER_EX, false);

    private final String name;
    private final DBIcon icon;
    private final boolean supported;

    private VQBJoinType(String string2, DBIcon dBIcon, boolean bl) {
        this.name = string2;
        this.icon = dBIcon;
        this.supported = bl;
    }

    public String getName() {
        return this.name;
    }

    public DBIcon getIcon() {
        return this.icon;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public static VQBJoinType getByJoin(Join join) {
        if (join.isSimple()) {
            return SIMPLE;
        }
        if (join.isFull()) {
            return FULL_OUTER;
        }
        if (join.isSimple()) {
            return INNER;
        }
        if (join.isRight()) {
            return RIGHT;
        }
        if (join.isLeft()) {
            return LEFT;
        }
        return INNER;
    }

    public static VQBJoinType getByName(String string) {
        VQBJoinType[] vQBJoinTypeArray = VQBJoinType.values();
        int n = vQBJoinTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VQBJoinType vQBJoinType = vQBJoinTypeArray[n2];
            if (vQBJoinType.name.equals(string)) {
                return vQBJoinType;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Bad join type name: " + string);
    }

    public void setJoinType(Join join) {
        join.setSimple(false);
        join.setInner(false);
        join.setOuter(false);
        join.setLeft(false);
        join.setRight(false);
        join.setCross(false);
        join.setFull(false);
        join.setNatural(false);
        switch (this) {
            case SIMPLE: {
                join.setSimple(true);
                break;
            }
            case INNER: {
                join.setInner(true);
                break;
            }
            case LEFT: 
            case LEFT_EX: {
                join.setLeft(true);
                break;
            }
            case RIGHT: 
            case RIGHT_EX: {
                join.setRight(true);
                break;
            }
            case FULL_OUTER: 
            case FULL_OUTER_EX: {
                join.setFull(true);
                join.setOuter(true);
            }
        }
    }
}

