/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.handlers;

import com.dbeaver.ee.vqb.internal.ui.VQBUIActivator;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.handlers.VQBAbstractHandler;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;

public class OpenQueryBuilderHandler
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(OpenQueryBuilderHandler.class);

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IEditorPart iEditorPart = HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        if (iEditorPart instanceof SQLEditor) {
            SQLEditor sQLEditor = (SQLEditor)iEditorPart;
            if (sQLEditor.getExtraPresentationState() == SQLEditorPresentation.ActivationType.HIDDEN) {
                boolean bl = sQLEditor.getExtraPresentation() == null;
                sQLEditor.showExtraPresentation(true, true);
                SQLEditorPresentation sQLEditorPresentation = sQLEditor.getExtraPresentation();
                if (!bl && sQLEditorPresentation instanceof VQBEditorPresentation) {
                    ((VQBEditorPresentation)sQLEditorPresentation).parseActiveQuery();
                }
            } else {
                SQLEditorPresentation sQLEditorPresentation = sQLEditor.getExtraPresentation();
                if (sQLEditorPresentation instanceof VQBEditorPresentation && ((VQBEditorPresentation)sQLEditorPresentation).isDirty()) {
                    int n;
                    ConfirmationDialog confirmationDialog = null;
                    if (VQBUIActivator.getDefault().getPreferences().getBoolean("vqb.save.query.always")) {
                        n = 2;
                    } else {
                        confirmationDialog = new ConfirmationDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), "Query Save", null, "You have unsaved changes in your active query.\nDo you want to save it back to SQL editor?", 4, ConfirmationDialog.getButtonLabels((int)6), ConfirmationDialog.getDefaultIndex((int)6, (int)4), "Save always", false);
                        n = confirmationDialog.open();
                    }
                    if (n == 1) {
                        return null;
                    }
                    if (n == 2) {
                        if (confirmationDialog != null && confirmationDialog.getToggleState()) {
                            VQBUIActivator.getDefault().getPreferences().setValue("vqb.save.query.always", true);
                        }
                        ((VQBEditorPresentation)sQLEditorPresentation).doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                }
                sQLEditor.showExtraPresentation(false, false);
            }
        }
        VQBAbstractHandler.updateEditorCommandStates();
        return null;
    }

    public void updateElement(UIElement uIElement, Map map) {
        IWorkbenchWindow iWorkbenchWindow = (IWorkbenchWindow)uIElement.getServiceLocator().getService(IWorkbenchWindow.class);
        if (iWorkbenchWindow == null || iWorkbenchWindow.getActivePage() == null) {
            return;
        }
        IEditorPart iEditorPart = iWorkbenchWindow.getActivePage().getActiveEditor();
        if (iEditorPart instanceof SQLEditor) {
            uIElement.setChecked(((SQLEditor)iEditorPart).getExtraPresentationState() != SQLEditorPresentation.ActivationType.HIDDEN);
        }
    }
}

