/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryElements;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.eclipse.jface.viewers.EditingSupport;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;

abstract class VQBPanelQueryExpression<ITEM>
extends VQBPanelQueryElements<ITEM> {
    public final Object[] EMPTY_CHILDREN = new Object[0];

    protected VQBPanelQueryExpression(VQBEditorPresentation vQBEditorPresentation) {
        super(vQBEditorPresentation);
    }

    @Override
    protected TreeContentProvider makeContentProvider() {
        return new ExpressionTreeContentProvider();
    }

    @Override
    protected void loadElements() {
        SelectBody selectBody = this.getQueryInfo().getParsedQuery().getSelectBody();
        if (selectBody instanceof PlainSelect) {
            this.elementViewer.setInput((Object)selectBody);
        } else {
            this.elementViewer.setInput(new ArrayList(0));
        }
        this.elementViewer.expandAll();
    }

    @Override
    protected void fillColumns(ViewerColumnController<Object, ITEM> viewerColumnController) {
        viewerColumnController.addColumn("Expression", "Compound Expression", 16384, true, true, object -> {
            Expression expression = this.getItemExpression(object);
            if (VQBUtils.isCompoundExpression(expression)) {
                if (expression instanceof Parenthesis) {
                    return "( ... )";
                }
                String string = ((BinaryExpression)expression).getStringExpression();
                return String.valueOf(((BinaryExpression)expression).isNot() ? "NOT " : "") + string;
            }
            return expression.toString();
        }, this.makeExpressionEditSupport());
    }

    protected EditingSupport makeExpressionEditSupport() {
        return null;
    }

    protected Expression getItemExpression(Object object) {
        if (object instanceof Expression) {
            return (Expression)object;
        }
        return this.getExpression(object);
    }

    @Override
    protected DBIcon getDefaultIcon() {
        return DBIcon.TREE_FUNCTION;
    }

    protected abstract List<ITEM> extractRootItems(PlainSelect var1);

    protected abstract Expression getExpression(ITEM var1);

    protected class ExpressionTreeContentProvider
    extends TreeContentProvider {
        protected ExpressionTreeContentProvider() {
        }

        public Object getParent(Object object) {
            return super.getParent(object);
        }

        public Object[] getElements(Object object) {
            if (object instanceof PlainSelect) {
                List list = VQBPanelQueryExpression.this.extractRootItems((PlainSelect)object);
                if (list == null) {
                    return VQBPanelQueryExpression.this.EMPTY_CHILDREN;
                }
                return list.toArray();
            }
            return this.getChildren(object);
        }

        public Object[] getChildren(Object object) {
            Expression expression = VQBPanelQueryExpression.this.getItemExpression(object);
            if (expression instanceof BinaryExpression) {
                BinaryExpression binaryExpression = (BinaryExpression)expression;
                ArrayList<Expression> arrayList = new ArrayList<Expression>();
                VQBQueryInfo vQBQueryInfo = VQBPanelQueryExpression.this.getQueryInfo();
                VQBUtils.collectNestedConditions(vQBQueryInfo, arrayList, (Expression)binaryExpression, binaryExpression.getLeftExpression());
                VQBUtils.collectNestedConditions(vQBQueryInfo, arrayList, (Expression)binaryExpression, binaryExpression.getRightExpression());
                return arrayList.toArray();
            }
            if (expression instanceof Parenthesis) {
                return new Object[]{((Parenthesis)expression).getExpression()};
            }
            return VQBPanelQueryExpression.this.EMPTY_CHILDREN;
        }

        public boolean hasChildren(Object object) {
            if (object instanceof PlainSelect) {
                return true;
            }
            Expression expression = VQBPanelQueryExpression.this.getItemExpression(object);
            return object instanceof Expression && VQBUtils.isCompoundExpression(expression);
        }
    }
}

