/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor;

import com.dbeaver.ee.vqb.VQBUtils;
import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.builder.VQBQueryParser;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorDecorator;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.part.QueryColumnPart;
import com.dbeaver.ee.vqb.ui.part.QueryJoinPart;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.command.BendpointCommand;
import org.jkiss.dbeaver.ext.erd.command.NodeMoveCommand;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ext.erd.model.ERDDecorator;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class VQBEditorPart
extends ERDEditorPart {
    private static final Log log = Log.getLog(VQBEditorPart.class);
    @NotNull
    private final VQBEditorPresentation presentation;
    @Nullable
    private VQBQueryInfo queryInfo;
    @NotNull
    private final QueryGeneratorJob generatorJob = new QueryGeneratorJob();

    VQBEditorPart(VQBEditorPresentation vQBEditorPresentation) {
        this.presentation = vQBEditorPresentation;
    }

    public VQBEditorPresentation getPresentation() {
        return this.presentation;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.presentation.getSQLEditor().getDataSource();
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean hasProgressControl() {
        return false;
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = UIUtils.createPlaceholder((Composite)composite, (int)1);
        if (composite.getLayout() instanceof GridLayout) {
            composite2.setLayoutData((Object)new GridData(1808));
        }
        Composite composite3 = UIUtils.createPlaceholder((Composite)composite2, (int)1);
        composite3.setLayout((Layout)new FillLayout());
        composite3.setLayoutData((Object)new GridData(1808));
        super.createPartControl(composite3);
        ToolBarManager toolBarManager = new ToolBarManager();
        this.fillDefaultEditorContributions((IContributionManager)toolBarManager);
        ToolBar toolBar = toolBarManager.createControl(composite2);
        toolBar.setLayoutData((Object)new GridData(128));
        this.getCommandStack().addCommandStackEventListener(commandStackEvent -> {
            switch (commandStackEvent.getDetail()) {
                case 8: 
                case 16: 
                case 32: {
                    Command command = commandStackEvent.getCommand();
                    if (command instanceof NodeMoveCommand || command instanceof BendpointCommand) break;
                    this.processQueryChangeCommand(command);
                }
            }
        });
        UIUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.getSite(), (Control)this.getGraphicalControl());
        EditorUtils.trackControlContext((IWorkbenchSite)this.getSite(), (Control)this.getGraphicalControl(), (String)"org.jkiss.dbeaver.ui.editors.sql.script.focused");
    }

    private void processQueryChangeCommand(Command command) {
        this.scheduleQueryGenerator();
    }

    public void scheduleQueryGenerator() {
        this.generatorJob.schedule(100L);
    }

    protected void registerDropTargetListeners(GraphicalViewer graphicalViewer) {
        super.registerDropTargetListeners(graphicalViewer);
    }

    protected ERDDecorator createDecorator() {
        return new VQBEditorDecorator(this);
    }

    protected void loadDiagram(boolean bl) {
        if (this.queryInfo == null || this.queryInfo.getQuery() == null || CommonUtils.isEmpty((String)this.queryInfo.getQuery().getText())) {
            this.setErrorMessage("No Active Query.\nDrag-and-drop tables from the database navigator or use the palette.\nDrag-n-drop columns to join tables.");
        }
        this.loadDiagramFromQuery();
    }

    public void loadQuery(SQLQuery sQLQuery) {
        if (this.queryInfo != null && this.queryInfo.getQuery() != null && this.queryInfo.getQuery().equals((Object)sQLQuery) && this.queryInfo.getQuery().getOffset() == sQLQuery.getOffset() && this.queryInfo.getQuery().getLength() == sQLQuery.getLength()) {
            return;
        }
        if (this.isDirty() && !UIUtils.confirmAction((Shell)this.getSite().getShell(), (String)"Query Builder", (String)"You have unsaved changes in your active query.\nDo you want to replace it with new query?")) {
            return;
        }
        Statement statement = null;
        if (!CommonUtils.isEmptyTrimmed((String)sQLQuery.getText())) {
            statement = sQLQuery.getStatement();
            if (statement == null) {
                Throwable throwable = sQLQuery.getParseError();
                if (throwable != null) {
                    throwable = GeneralUtils.getRootCause((Throwable)throwable);
                    DBUserInterface.getInstance().showError("Query parse failed", "Could not parse SQL query:\n" + sQLQuery.getText(), throwable);
                }
            } else if (!(statement instanceof Select)) {
                UIUtils.showMessageBox((Shell)this.getSite().getShell(), (String)"Query parse failed", (String)"Only SELECT queries are supported", (int)1);
            } else {
                this.setErrorMessage(null);
            }
        }
        if (statement == null || !(statement instanceof Select)) {
            statement = VQBUtils.createEmptySelectStatement();
        }
        this.queryInfo = new VQBQueryInfo(sQLQuery, (Select)statement);
        this.refreshDiagram(true, true);
    }

    private void loadDiagramFromQuery() {
        if (this.getDiagramPart() == null) {
            return;
        }
        this.getDiagramPart().getDiagram().clear();
        this.getDiagramPart().rearrangeDiagram();
        DatabaseLoadService<EntityDiagram> databaseLoadService = new DatabaseLoadService<EntityDiagram>("Parse query", this.queryInfo.getQuery().getDataSource()){

            public EntityDiagram evaluate(DBRProgressMonitor dBRProgressMonitor) {
                EntityDiagram entityDiagram = new EntityDiagram(VQBEditorPart.this.getDecorator(), null, "Query Builder");
                entityDiagram.setLayoutManualAllowed(true);
                VQBQueryParser vQBQueryParser = new VQBQueryParser(VQBEditorPart.this.queryInfo);
                vQBQueryParser.loadDiagramFromQuery(dBRProgressMonitor, entityDiagram);
                return entityDiagram;
            }
        };
        this.diagramLoadingJob = LoadingJob.createService((ILoadService)databaseLoadService, (ILoadVisualizer)new DiagramLoaderVisualizer((ILoadService<EntityDiagram>)databaseLoadService, (Composite)this.getGraphicalControl()));
        this.diagramLoadingJob.schedule();
    }

    public VQBQueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    void resetDirtyFlag() {
        this.setDirty(false);
    }

    private void refreshDiagramState() {
        for (EntityPart entityPart : this.getDiagramPart().getEntityParts()) {
            for (Object e : entityPart.getChildren()) {
                if (!(e instanceof QueryColumnPart)) continue;
                ((QueryColumnPart)((Object)e)).updateCheckState();
            }
            for (Object e : entityPart.getSourceConnections()) {
                if (!(e instanceof QueryJoinPart)) continue;
                ((QueryJoinPart)((Object)e)).updateJoinType();
            }
        }
    }

    private class DiagramLoaderVisualizer
    extends ProgressLoaderVisualizer<EntityDiagram> {
        DiagramLoaderVisualizer(ILoadService<EntityDiagram> iLoadService, Composite composite) {
            super(iLoadService, composite);
        }

        public void visualizeLoading() {
            super.visualizeLoading();
        }

        public void completeLoading(EntityDiagram entityDiagram) {
            super.completeLoading((Object)entityDiagram);
            super.visualizeLoading();
            if (!entityDiagram.getEntities().isEmpty()) {
                VQBEditorPart.this.setErrorMessage(null);
            }
            if (entityDiagram != null) {
                VQBEditorPart.this.getGraphicalViewer().setContents((Object)entityDiagram);
                VQBEditorPart.this.getDiagramPart().rearrangeDiagram();
                VQBEditorPart.this.presentation.refreshStatement();
            }
            VQBEditorPart.this.resetDirtyFlag();
        }
    }

    private class QueryGeneratorJob
    extends AbstractJob {
        QueryGeneratorJob() {
            super("Generate SQL query from diagram");
            this.setUser(false);
        }

        protected IStatus run(DBRProgressMonitor dBRProgressMonitor) {
            if (VQBEditorPart.this.getDataSource() == null) {
                return GeneralUtils.makeErrorStatus((String)"Can't generate query - not connected to a database");
            }
            VQBQueryParser vQBQueryParser = new VQBQueryParser(VQBEditorPart.this.getQueryInfo());
            vQBQueryParser.updateDiagramFromQuery(dBRProgressMonitor, VQBEditorPart.this.getDiagram());
            UIUtils.asyncExec(() -> {
                VQBEditorPart.this.setDirty(true);
                VQBEditorPart.this.refreshDiagramState();
                VQBEditorPart.this.presentation.refreshStatement();
            });
            return Status.OK_STATUS;
        }
    }
}

