/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.builder;

import com.dbeaver.ee.vqb.ui.builder.VQBQueryInfo;
import com.dbeaver.ee.vqb.ui.model.ERDJoin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.WithItem;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.model.ERDContainer;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.ERDUtils;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLIdentifierDetector;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLSearchUtils;
import org.jkiss.utils.CommonUtils;

public class VQBQueryParser {
    private static final Log log = Log.getLog(VQBQueryParser.class);
    private final VQBQueryInfo queryInfo;
    private SQLIdentifierDetector identifierDetector;

    public VQBQueryParser(VQBQueryInfo vQBQueryInfo) {
        this.queryInfo = vQBQueryInfo;
        SQLDialect sQLDialect = SQLUtils.getDialectFromDataSource((DBPDataSource)vQBQueryInfo.getQuery().getDataSource());
        this.identifierDetector = new SQLIdentifierDetector(sQLDialect.getStructSeparator(), sQLDialect.getIdentifierQuoteStrings());
    }

    public void loadDiagramFromQuery(DBRProgressMonitor dBRProgressMonitor, EntityDiagram entityDiagram) {
        if (this.queryInfo.getParsedQuery() != null) {
            this.fillDiagramFromSelect(dBRProgressMonitor, entityDiagram);
        }
    }

    public void updateDiagramFromQuery(DBRProgressMonitor dBRProgressMonitor, EntityDiagram entityDiagram) {
        if (this.queryInfo.getParsedQuery() != null) {
            SelectBody selectBody = this.queryInfo.getParsedQuery().getSelectBody();
            if (selectBody instanceof WithItem) {
                selectBody = ((WithItem)selectBody).getSelectBody();
            }
            if (!(selectBody instanceof PlainSelect)) {
                log.debug((Object)("Query is not a plain select: " + selectBody));
                return;
            }
            ArrayList<ERDEntity> arrayList = new ArrayList<ERDEntity>(entityDiagram.getEntities());
            ERDEntity eRDEntity = null;
            for (ERDEntity eRDEntity2 : arrayList) {
                if (eRDEntity2.isPrimary()) {
                    eRDEntity = eRDEntity2;
                }
                for (ERDEntityAttribute eRDEntityAttribute : eRDEntity2.getAttributes()) {
                    eRDEntityAttribute.setChecked(false);
                }
            }
            this.updateAttributesState((PlainSelect)selectBody, eRDEntity, arrayList);
        }
    }

    private void fillDiagramFromSelect(DBRProgressMonitor dBRProgressMonitor, EntityDiagram entityDiagram) {
        List list;
        SelectBody selectBody = this.queryInfo.getParsedQuery().getSelectBody();
        if (selectBody instanceof WithItem) {
            selectBody = ((WithItem)selectBody).getSelectBody();
        }
        if (!(selectBody instanceof PlainSelect)) {
            log.debug((Object)("Query is not a plain select: " + selectBody));
            return;
        }
        PlainSelect plainSelect = (PlainSelect)selectBody;
        FromItem fromItem = plainSelect.getFromItem();
        ERDEntity eRDEntity = this.addQuerySourceItem(dBRProgressMonitor, entityDiagram, fromItem);
        ArrayList<ERDEntity> arrayList = new ArrayList<ERDEntity>();
        if (eRDEntity != null) {
            eRDEntity.setPrimary(true);
            arrayList.add(eRDEntity);
        }
        if (!CommonUtils.isEmpty((Collection)(list = plainSelect.getJoins()))) {
            ERDEntity eRDEntity2;
            ERDEntity eRDEntity3 = new HashMap();
            for (Join join : list) {
                eRDEntity2 = this.addQuerySourceItem(dBRProgressMonitor, entityDiagram, join.getRightItem());
                if (eRDEntity2 == null) {
                    log.debug((Object)("Can't find joined table " + join.getRightItem()));
                    continue;
                }
                arrayList.add(eRDEntity2);
                eRDEntity3.put(join, eRDEntity2);
            }
            for (Join join : list) {
                eRDEntity2 = (ERDEntity)eRDEntity3.get(join);
                if (eRDEntity2 == null) continue;
                Expression expression = join.getOnExpression();
                ERDJoin eRDJoin = null;
                if (expression != null) {
                    eRDJoin = this.addJoinOnExpression(arrayList, eRDEntity2, expression);
                } else if (join.isSimple() && plainSelect.getWhere() != null) {
                    eRDJoin = this.addJoinOnCondition(null, arrayList, eRDEntity2, eRDEntity, plainSelect.getWhere());
                }
                if (eRDJoin == null) {
                    eRDJoin = new ERDJoin(eRDEntity2, eRDEntity, false);
                }
                eRDJoin.setUserData(join);
            }
        }
        this.updateAttributesState(plainSelect, eRDEntity, arrayList);
        for (ERDEntity eRDEntity3 : arrayList) {
            eRDEntity3.addModelRelations(dBRProgressMonitor, (ERDContainer)entityDiagram, false, false);
        }
    }

    private void updateAttributesState(PlainSelect plainSelect, ERDEntity eRDEntity, List<ERDEntity> list) {
        List list2 = plainSelect.getSelectItems();
        if (list2 != null) {
            int n = 0;
            while (n < list2.size()) {
                Column column;
                Expression expression;
                SelectItem selectItem = (SelectItem)list2.get(n);
                if (selectItem instanceof SelectExpressionItem) {
                    expression = ((SelectExpressionItem)selectItem).getExpression();
                    if (expression instanceof Column) {
                        column = (Column)expression;
                        String string = column.getColumnName();
                        Table table = column.getTable();
                        ERDEntity eRDEntity2 = this.findEntityByTable(list, eRDEntity, table);
                        if (eRDEntity2 != null) {
                            ERDEntityAttribute eRDEntityAttribute = (ERDEntityAttribute)DBUtils.findObject((List)eRDEntity2.getAttributes(), (String)string);
                            if (eRDEntityAttribute != null) {
                                eRDEntityAttribute.setChecked(true);
                                eRDEntityAttribute.setUserData((Object)selectItem);
                                Alias alias = ((SelectExpressionItem)selectItem).getAlias();
                                if (alias != null && !CommonUtils.isEmpty((String)alias.getName())) {
                                    eRDEntityAttribute.setAlias(alias.getName());
                                }
                            } else {
                                log.debug((Object)("Can't detect table " + eRDEntity2.getName() + " column " + string));
                            }
                        } else {
                            log.debug((Object)("Can't detect column table: " + expression));
                        }
                    }
                } else if (selectItem instanceof AllTableColumns) {
                    expression = ((AllTableColumns)selectItem).getTable();
                    column = this.findEntityByTable(list, eRDEntity, (Table)expression);
                    if (column != null) {
                        for (String string : column.getAttributes()) {
                            string.setChecked(true);
                            string.setUserData((Object)selectItem);
                        }
                    } else {
                        log.debug((Object)("Can't detect selected table " + selectItem));
                    }
                }
                ++n;
            }
        }
    }

    private ERDJoin addJoinOnCondition(ERDJoin eRDJoin, List<ERDEntity> list, ERDEntity eRDEntity, ERDEntity eRDEntity2, Expression expression) {
        Expression expression2 = this.extractLeftExpression(expression);
        Expression expression3 = this.extractRightExpression(expression);
        if (expression instanceof AndExpression || expression instanceof OrExpression) {
            eRDJoin = this.addJoinOnCondition(eRDJoin, list, eRDEntity, eRDEntity2, expression2);
            eRDJoin = this.addJoinOnCondition(eRDJoin, list, eRDEntity, eRDEntity2, expression3);
        } else if (expression instanceof EqualsTo && expression2 instanceof Column && expression3 instanceof Column) {
            Table table = ((Column)expression2).getTable();
            Table table2 = ((Column)expression3).getTable();
            if (table != null && table2 != null) {
                ERDEntity eRDEntity3 = this.findEntityByTable(list, eRDEntity, table);
                ERDEntity eRDEntity4 = this.findEntityByTable(list, eRDEntity, table2);
                if (eRDEntity3 != null && eRDEntity4 != null && (eRDEntity3 == eRDEntity || eRDEntity4 == eRDEntity)) {
                    String string = ((Column)expression2).getColumnName();
                    String string2 = ((Column)expression3).getColumnName();
                    if (!CommonUtils.isEmpty((String)string) && !CommonUtils.isEmpty((String)string2)) {
                        ERDEntityAttribute eRDEntityAttribute = (ERDEntityAttribute)DBUtils.findObject((List)eRDEntity3.getAttributes(), (String)string);
                        ERDEntityAttribute eRDEntityAttribute2 = (ERDEntityAttribute)DBUtils.findObject((List)eRDEntity4.getAttributes(), (String)string2);
                        if (eRDEntityAttribute != null && eRDEntityAttribute2 != null) {
                            this.queryInfo.excludeWhereCondition(expression);
                            if (eRDEntity4 == eRDEntity && eRDEntity3 == eRDEntity2) {
                                ERDEntity eRDEntity5 = eRDEntity3;
                                eRDEntity3 = eRDEntity4;
                                eRDEntity4 = eRDEntity5;
                                ERDEntityAttribute eRDEntityAttribute3 = eRDEntityAttribute;
                                eRDEntityAttribute = eRDEntityAttribute2;
                                eRDEntityAttribute2 = eRDEntityAttribute3;
                            }
                            if (eRDJoin == null) {
                                eRDJoin = new ERDJoin(eRDEntity3, eRDEntity4, false);
                            }
                            eRDJoin.addCondition(eRDEntityAttribute, eRDEntityAttribute2);
                        }
                    }
                }
            }
        }
        return eRDJoin;
    }

    private Expression extractLeftExpression(Expression expression) {
        while (expression instanceof Parenthesis) {
            expression = ((Parenthesis)expression).getExpression();
        }
        return expression instanceof BinaryExpression ? ((BinaryExpression)expression).getLeftExpression() : null;
    }

    private Expression extractRightExpression(Expression expression) {
        while (expression instanceof Parenthesis) {
            expression = ((Parenthesis)expression).getExpression();
        }
        return expression instanceof BinaryExpression ? ((BinaryExpression)expression).getRightExpression() : null;
    }

    private ERDJoin addJoinOnExpression(List<ERDEntity> list, ERDEntity eRDEntity, Expression expression) {
        if (expression instanceof BinaryExpression) {
            return this.makeJoinFromCondition(null, list, eRDEntity, (BinaryExpression)expression);
        }
        return null;
    }

    private ERDJoin makeJoinFromCondition(ERDJoin eRDJoin, List<ERDEntity> list, ERDEntity eRDEntity, BinaryExpression binaryExpression) {
        Expression expression = binaryExpression.getLeftExpression();
        Expression expression2 = binaryExpression.getRightExpression();
        if (binaryExpression instanceof AndExpression) {
            if (binaryExpression.getLeftExpression() instanceof BinaryExpression) {
                eRDJoin = this.makeJoinFromCondition(eRDJoin, list, eRDEntity, (BinaryExpression)binaryExpression.getLeftExpression());
            }
            if (binaryExpression.getRightExpression() instanceof BinaryExpression) {
                eRDJoin = this.makeJoinFromCondition(eRDJoin, list, eRDEntity, (BinaryExpression)binaryExpression.getRightExpression());
            }
        } else if (binaryExpression instanceof EqualsTo && expression instanceof Column && expression2 instanceof Column) {
            Table table = ((Column)expression).getTable();
            Table table2 = ((Column)expression2).getTable();
            if (table != null && table2 != null) {
                Object object;
                Object object2;
                ERDEntity eRDEntity2 = this.findEntityByTable(list, eRDEntity, table);
                ERDEntity eRDEntity3 = this.findEntityByTable(list, eRDEntity, table2);
                if (eRDEntity == eRDEntity3) {
                    object2 = eRDEntity2;
                    eRDEntity2 = eRDEntity3;
                    eRDEntity3 = object2;
                    object = expression;
                    expression = expression2;
                    expression2 = object;
                }
                if (eRDEntity2 != null && eRDEntity3 != null) {
                    if (eRDJoin == null) {
                        eRDJoin = new ERDJoin(eRDEntity2, eRDEntity3, false);
                    }
                    object2 = ((Column)expression).getColumnName();
                    object = ((Column)expression2).getColumnName();
                    if (!CommonUtils.isEmpty((String)object2) && !CommonUtils.isEmpty((String)object)) {
                        ERDEntityAttribute eRDEntityAttribute = (ERDEntityAttribute)DBUtils.findObject((List)eRDEntity2.getAttributes(), (String)object2);
                        ERDEntityAttribute eRDEntityAttribute2 = (ERDEntityAttribute)DBUtils.findObject((List)eRDEntity3.getAttributes(), (String)object);
                        if (eRDEntityAttribute != null && eRDEntityAttribute2 != null) {
                            eRDJoin.addCondition(eRDEntityAttribute, eRDEntityAttribute2);
                        }
                    }
                }
            }
        } else {
            log.debug((Object)("Can't parse expression [" + binaryExpression + "]. Skip."));
        }
        return eRDJoin;
    }

    private ERDEntity findEntityByTable(List<ERDEntity> list, ERDEntity eRDEntity, Table table) {
        String string;
        String string2 = string = table.getAlias() != null ? table.getAlias().getName() : null;
        if (CommonUtils.isEmpty((String)string) && CommonUtils.isEmpty((String)table.getName())) {
            return eRDEntity;
        }
        for (ERDEntity eRDEntity2 : list) {
            DBSSchema dBSSchema;
            if (string != null ? string.equals(eRDEntity2.getAlias()) : table.getName().equals(eRDEntity2.getAlias())) {
                return eRDEntity2;
            }
            DBSEntity dBSEntity = (DBSEntity)eRDEntity2.getObject();
            if (table.getDatabase() != null && !CommonUtils.isEmpty((String)table.getDatabase().getDatabaseName()) && ((dBSSchema = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)dBSEntity)) == null || !dBSSchema.getName().equals(table.getDatabase().getDatabaseName())) || !CommonUtils.isEmpty((String)table.getSchemaName()) && ((dBSSchema = (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)dBSEntity)) == null || !dBSSchema.getName().equals(table.getSchemaName())) || !dBSEntity.getName().equals(table.getName())) continue;
            return eRDEntity2;
        }
        return null;
    }

    private ERDEntity addQuerySourceItem(DBRProgressMonitor dBRProgressMonitor, EntityDiagram entityDiagram, FromItem fromItem) {
        if (fromItem instanceof Table) {
            ERDEntity eRDEntity;
            Table table = (Table)fromItem;
            DBPDataSource dBPDataSource = this.queryInfo.getQuery().getDataSource();
            if (dBPDataSource == null) {
                log.error((Object)"Can't create query builder without live connection");
                return null;
            }
            DBSObjectContainer dBSObjectContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dBPDataSource);
            if (dBSObjectContainer == null) {
                log.error((Object)("Data source " + dBPDataSource.getName() + " is not an object container"));
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (table.getDatabase() != null && !CommonUtils.isEmpty((String)table.getDatabase().getDatabaseName())) {
                arrayList.add(table.getDatabase().getDatabaseName());
            }
            if (!CommonUtils.isEmpty((String)table.getSchemaName())) {
                arrayList.add(table.getSchemaName());
            }
            arrayList.add(table.getName());
            DBSObject[] dBSObjectArray = DBUtils.getSelectedObjects((DBSObject)dBPDataSource);
            DBSObjectContainer[] dBSObjectContainerArray = new DBSObjectContainer[dBSObjectArray.length];
            int n = 0;
            while (n < dBSObjectArray.length) {
                dBSObjectContainerArray[n] = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dBSObjectArray[n]);
                ++n;
            }
            DBSObject dBSObject = SQLSearchUtils.findObjectByFQN((DBRProgressMonitor)dBRProgressMonitor, (DBSObjectContainer)dBSObjectContainer, (DBPDataSource)dBPDataSource, arrayList, (boolean)false, (SQLIdentifierDetector)this.identifierDetector);
            if (dBSObject == null) {
                DBSObjectContainer[] dBSObjectContainerArray2 = dBSObjectContainerArray;
                int n2 = dBSObjectContainerArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    eRDEntity = dBSObjectContainerArray2[n3];
                    if (eRDEntity != null && (dBSObject = SQLSearchUtils.findObjectByFQN((DBRProgressMonitor)dBRProgressMonitor, (DBSObjectContainer)eRDEntity, (DBPDataSource)dBPDataSource, arrayList, (boolean)false, (SQLIdentifierDetector)this.identifierDetector)) != null) break;
                    ++n3;
                }
            }
            if (dBSObject instanceof DBSEntity) {
                eRDEntity = ERDUtils.makeEntityFromObject((DBRProgressMonitor)dBRProgressMonitor, (EntityDiagram)entityDiagram, (DBSEntity)((DBSEntity)dBSObject), (Object)fromItem);
                if (fromItem.getAlias() != null) {
                    eRDEntity.setAlias(fromItem.getAlias().getName());
                }
                entityDiagram.addEntity(eRDEntity, false);
                return eRDEntity;
            }
        }
        return null;
    }
}

