/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.resultset.xml;

import com.dbeaver.ee.runtime.internal.ui.UiMessages;
import com.dbeaver.ee.runtime.internal.ui.resultset.xml.XMLRenderer;
import com.dbeaver.ee.runtime.ui.resultset.document.AbstractDocumentPresentation;
import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentRenderer;
import java.io.InputStream;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.impl.data.DBDDocumentContentProxy;
import org.jkiss.dbeaver.model.impl.data.DBDDocumentXML;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.ui.editors.BinaryEditorInput;
import org.jkiss.dbeaver.ui.editors.xml.XMLEditor;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;

public class XMLPresentation
extends AbstractDocumentPresentation {
    private static final Log log = Log.getLog(XMLPresentation.class);

    @Override
    @NotNull
    protected IDocumentRenderer createRenderer(@NotNull IDocumentFrame iDocumentFrame) {
        return new XMLRenderer(iDocumentFrame);
    }

    @Override
    @NotNull
    protected IEditorInput createEditorInput(@NotNull DBDDocument dBDDocument) {
        return new BinaryEditorInput("#document", this.convertDocumentToData(dBDDocument), false, "UTF-8");
    }

    @Override
    @NotNull
    protected IEditorPart createEditorPart() throws DBException {
        return new XMLEditor();
    }

    @Override
    @NotNull
    public DBDDocument createDocumentFromContent(@NotNull DBDContent dBDContent) {
        try {
            return new XMLContentDocument(dBDContent);
        }
        catch (DBException dBException) {
            log.error((Object)dBException);
            return null;
        }
    }

    @Override
    @NotNull
    protected DBDDocument createNewDocument() throws DBException {
        try {
            return new DBDDocumentXML(XMLUtils.createDocument());
        }
        catch (XMLException xMLException) {
            throw new DBException(UiMessages.XMLPresentation_e_create_xml_new, (Throwable)xMLException);
        }
    }

    private static class XMLContentDocument
    extends DBDDocumentContentProxy {
        public XMLContentDocument(DBDContent dBDContent) throws DBException {
            super(dBDContent);
        }

        @NotNull
        protected DBDDocument createDocumentFromContent(@NotNull DBDContent dBDContent) throws DBException {
            try {
                Document document;
                block12: {
                    DBDContentStorage dBDContentStorage = dBDContent.getContents((DBRProgressMonitor)new VoidProgressMonitor());
                    if (dBDContentStorage != null) {
                        Throwable throwable = null;
                        Object var5_6 = null;
                        try (InputStream inputStream = dBDContentStorage.getContentStream();){
                            document = XMLUtils.parseDocument((InputStream)inputStream);
                            break block12;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    document = XMLUtils.createDocument();
                }
                return new DBDDocumentXML(document);
            }
            catch (Exception exception) {
                throw new DBException(UiMessages.XMLPresentation_e_create_xml, (Throwable)exception);
            }
        }
    }
}

