/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.resultset.timeseries;

import com.dbeaver.ee.model.timeseries.TSDataProvider;
import com.dbeaver.ee.model.timeseries.TSMeasurement;
import com.dbeaver.ee.model.timeseries.TSPoint;
import com.dbeaver.ee.model.timeseries.TSProjection;
import com.dbeaver.ee.runtime.ui.resultset.timeseries.AbstractTimeSeriesPresentation;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.draw2d.IFigure;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.dataprovider.Sample;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.utils.CommonUtils;

public class TimeSeriesGraphPresentation
extends AbstractTimeSeriesPresentation {
    private static final Log log = Log.getLog(TimeSeriesGraphPresentation.class);
    private Object[][] rowData;

    @Override
    public void refreshData(boolean bl, boolean bl2, boolean bl3) {
        DBSDataContainer dBSDataContainer = this.getController().getDataContainer();
        TSDataProvider tSDataProvider = (TSDataProvider)Adapters.adapt((Object)dBSDataContainer, TSDataProvider.class);
        if (tSDataProvider == null) {
            DBUserInterface.getInstance().showError("No data provider", "Can't obtain time series data provider from " + dBSDataContainer);
            return;
        }
        List list = this.getController().getModel().getAllRows();
        this.rowData = new Object[list.size()][];
        int n = 0;
        while (n < list.size()) {
            this.rowData[n] = ((ResultSetRow)list.get(n)).getValues();
            ++n;
        }
        try {
            tSDataProvider.initData(this.getController().getModel().getAttributes(), this.rowData);
        }
        catch (DBException dBException) {
            DBUserInterface.getInstance().showError("Bad data", "Error settings initial data", (Throwable)dBException);
            return;
        }
        XYGraph xYGraph = new XYGraph();
        String string = tSDataProvider.getSeriesName();
        if (string != null) {
            xYGraph.setTitle(string);
        }
        xYGraph.setShowTitle(false);
        xYGraph.getPrimaryXAxis().setTitle("time");
        xYGraph.getPrimaryYAxis().setTitle("Measures");
        xYGraph.setRequestFocusEnabled(true);
        this.getGraphSystem().setContents((IFigure)xYGraph);
        xYGraph.getPrimaryXAxis().setDateEnabled(true);
        xYGraph.getPrimaryYAxis().setAutoScale(true);
        xYGraph.getPrimaryXAxis().setAutoScale(true);
        List list2 = tSDataProvider.getMeasurements();
        if (list2.size() == 1) {
            xYGraph.getPrimaryYAxis().setTitle(((TSMeasurement)list2.get(0)).getName());
        }
        List list3 = tSDataProvider.getProjections(this.rowData);
        for (TSMeasurement tSMeasurement : list2) {
            if (CommonUtils.isEmpty((Collection)list3)) {
                this.showPoints((IXYGraph)xYGraph, tSDataProvider, tSMeasurement, null);
                continue;
            }
            for (TSProjection tSProjection : list3) {
                this.showPoints((IXYGraph)xYGraph, tSDataProvider, tSMeasurement, tSProjection);
            }
        }
        super.refreshData(bl, bl2, bl3);
    }

    private void showPoints(IXYGraph iXYGraph, TSDataProvider tSDataProvider, TSMeasurement tSMeasurement, TSProjection tSProjection) {
        TSPoint tSPoint2;
        List list = null;
        try {
            list = tSDataProvider.getPoints(tSMeasurement, tSProjection, this.rowData);
        }
        catch (DBException dBException) {
            DBUserInterface.getInstance().showError("Bad points", "Error reading time series points", (Throwable)dBException);
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        CircularBufferDataProvider circularBufferDataProvider = new CircularBufferDataProvider(true);
        circularBufferDataProvider.setBufferSize(list.size());
        circularBufferDataProvider.setXAxisDateEnabled(true);
        circularBufferDataProvider.setChronological(true);
        for (TSPoint tSPoint2 : list) {
            circularBufferDataProvider.addSample((ISample)new Sample((double)tSPoint2.getX().getTime(), tSPoint2.getY().doubleValue()));
        }
        tSPoint2 = new Trace(tSProjection == null ? tSMeasurement.getName() : tSProjection.toString(), iXYGraph.getPrimaryXAxis(), iXYGraph.getPrimaryYAxis(), (IDataProvider)circularBufferDataProvider);
        tSPoint2.setPointStyle(Trace.PointStyle.POINT);
        tSPoint2.setAntiAliasing(true);
        tSPoint2.setPointSize(3);
        iXYGraph.addTrace((Trace)tSPoint2);
    }
}

