/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.resultset.document;

import com.dbeaver.ee.runtime.internal.ui.resultset.ResultsetMessages;
import com.dbeaver.ee.runtime.ui.resultset.document.AbstractDocumentPresentation;
import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentRenderer;
import java.io.InputStream;
import java.util.Date;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.utils.CommonUtils;

class DocumentFrame
implements IDocumentFrame {
    private static final int FRAME_MARGIN = 5;
    private static final int FRAME_BORDER = 5;
    private final AbstractDocumentPresentation presentation;
    private int frameNumber;
    @Nullable
    private DBDDocument document;
    private DBDContent content;
    private IDocumentRenderer renderer;
    private int topOffset = 0;
    private int headerHeight = 20;
    private Point size = new Point(0, 0);
    private ResultSetRow row;
    private Point selectionStart;
    private Point selectionEnd;
    private boolean selectionActive;
    private Composite editorFrame;
    private IEditorPart editor;
    private boolean editMode;
    private Composite buttonsPanel;

    DocumentFrame(AbstractDocumentPresentation abstractDocumentPresentation, int n) {
        this.presentation = abstractDocumentPresentation;
        this.frameNumber = n;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public ResultSetRow getRow() {
        return this.row;
    }

    @Override
    public boolean isSelected() {
        return this.presentation.getController().getCurrentRow() == this.row;
    }

    void setDocument(ResultSetRow resultSetRow, DBDDocument dBDDocument) {
        if (dBDDocument != null && dBDDocument == this.document) {
            return;
        }
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.row = resultSetRow;
        this.document = dBDDocument;
        this.renderer = dBDDocument != null ? this.presentation.createRenderer(this) : null;
    }

    public void dispose() {
        this.document = null;
    }

    public void setRow(DBDAttributeBinding dBDAttributeBinding, ResultSetRow resultSetRow) {
        Object[] objectArray = resultSetRow.getValues();
        Object object = objectArray[dBDAttributeBinding.getOrdinalPosition()];
        if (object instanceof DBDDocument) {
            this.setDocument(resultSetRow, (DBDDocument)object);
        } else if (object instanceof DBDContent) {
            this.content = (DBDContent)object;
            DBDDocument dBDDocument = this.presentation.createDocumentFromContent(this.content);
            this.setDocument(resultSetRow, dBDDocument);
        } else {
            this.setDocument(resultSetRow, null);
        }
    }

    private void updateSizesOnStructChange() {
        GC gC = new GC((Drawable)this.presentation.getControl());
        try {
            this.updateSizes(gC, false);
        }
        finally {
            gC.dispose();
        }
        this.presentation.updateMeasures(false);
    }

    public void updateSizes(GC gC, boolean bl) {
        this.headerHeight = UIUtils.getFontHeight((Font)this.presentation.getLargeFont()) + 20;
        this.size = this.renderer == null ? new Point(0, this.headerHeight) : this.renderer.computeSize(gC);
        this.size.x += 20;
        this.size.y += 20 + this.headerHeight;
        if (bl) {
            Rectangle rectangle = this.presentation.getControl().getClientArea();
            this.size.y = rectangle.height;
        }
    }

    public Composite getEditorFrame() {
        return this.editorFrame;
    }

    public void updateEditorBounds() {
        if (this.editorFrame == null) {
            return;
        }
        Rectangle rectangle = this.presentation.getControl().getClientArea();
        Rectangle rectangle2 = this.getBounds(rectangle);
        Point point = this.buttonsPanel.computeSize(-1, -1);
        this.buttonsPanel.setBounds(rectangle2.x + rectangle2.width - point.x - 5 - 2, rectangle2.y + 5 + 2, point.x, point.y);
        rectangle2.x += 9;
        rectangle2.y += 7 + this.headerHeight;
        rectangle2.height -= 14 + this.headerHeight;
        rectangle2.width -= 18;
        this.editorFrame.setBounds(rectangle2);
        if (this.editor != null) {
            this.editorFrame.layout(true, true);
            this.buttonsPanel.layout();
        }
    }

    @Override
    public IResultSetController getController() {
        return this.presentation.getController();
    }

    @Override
    public DBDDocument getDocument() {
        return this.document;
    }

    @Override
    public Composite getCanvas() {
        return this.presentation.getControl();
    }

    @Override
    public Point getSize() {
        return this.size;
    }

    @Override
    public int getTopOffset() {
        return this.topOffset;
    }

    public void setTopOffset(int n) {
        this.topOffset = n;
    }

    @Override
    public Point getSelectionStart() {
        return this.selectionStart;
    }

    @Override
    public Point getSelectionEnd() {
        return this.selectionEnd;
    }

    @Override
    public boolean isSelectionActive() {
        return this.selectionActive;
    }

    public boolean isInPosition(int n, int n2) {
        return n2 >= this.topOffset + 5 && n2 <= this.topOffset + this.size.y - 5 && n >= 5;
    }

    @NotNull
    public Rectangle getBounds(Rectangle rectangle) {
        int n = Math.max(this.size.x, rectangle.width);
        return new Rectangle(-this.presentation.getHorizontalOffset(), this.topOffset - this.presentation.getVerticalOffset(), Math.max(n, this.size.x), this.size.y);
    }

    public void paintFrame(GC gC, Canvas canvas, Rectangle rectangle) {
        rectangle.x += 5;
        rectangle.y += 5;
        rectangle.height -= 10;
        rectangle.width -= 10;
        Color color = this.presentation.getBackgroundNormal();
        if (this.row.getState() == 2) {
            color = this.presentation.getBackgroundAdded();
        } else if (this.row.getState() == 3) {
            color = this.presentation.getBackgroundDeleted();
        } else if (this.row.changes != null && this.row.changes.containsKey(this.presentation.getCurrentAttribute())) {
            color = this.presentation.getBackgroundModified();
        }
        gC.setBackground(color);
        gC.fillRectangle(rectangle);
        gC.setForeground(this.presentation.getColorShadow());
        gC.drawRectangle(rectangle);
        if (this.isSelected()) {
            gC.setForeground(this.presentation.getColorForeground());
            gC.drawRectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        }
        if (this.editMode) {
            gC.setForeground(this.presentation.getEditBorderColor());
            gC.drawRectangle(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        }
        rectangle.x += 5;
        rectangle.y += 5;
        rectangle.height -= 10;
        if (rectangle.y + this.headerHeight >= 0) {
            Date date;
            String string = this.getDocumentId();
            gC.setForeground(this.presentation.getColorForeground());
            gC.setFont(this.presentation.getLargeFont());
            String string2 = "[" + (this.row.getVisualNumber() + 1) + "] " + string;
            Point point = gC.stringExtent(string2);
            gC.drawText(string2, rectangle.x + 5, rectangle.y);
            gC.setForeground(this.presentation.getColorShadow());
            gC.setFont(this.presentation.getSmallFont());
            if (this.document != null && (date = (Date)this.document.getDocumentProperty("createTime")) != null) {
                gC.drawText(date.toString(), rectangle.x + 5 + point.x + 20, rectangle.y);
            }
            gC.drawLine(rectangle.x + 5, rectangle.y + this.headerHeight - 5, rectangle.width / 2 - 5, rectangle.y + this.headerHeight - 5);
        }
        rectangle.y += this.headerHeight;
        rectangle.height -= this.headerHeight;
        gC.setForeground(this.presentation.getColorForeground());
        gC.setFont(canvas.getFont());
        if (this.renderer != null) {
            this.renderer.paintDocument(gC, canvas, rectangle);
        }
        gC.setBackground(canvas.getBackground());
    }

    private String getDocumentId() {
        Object object;
        Object object2 = object = this.document == null ? null : this.document.getDocumentProperty("id");
        if (object == null) {
            return "Document";
        }
        return CommonUtils.toString((Object)object);
    }

    public String convertToString(boolean bl, DBDDisplayFormat dBDDisplayFormat) {
        if (this.renderer != null) {
            StringBuilder stringBuilder = new StringBuilder(128);
            if (bl) {
                stringBuilder.append(this.getDocumentId()).append("\n");
            }
            this.renderer.getContents(stringBuilder, this, dBDDisplayFormat);
            return stringBuilder.toString();
        }
        return null;
    }

    void onMouseMove(MouseEvent mouseEvent) {
        if (this.selectionActive) {
            this.selectionEnd = this.createTextPosition(mouseEvent);
            this.presentation.getControl().redraw();
        }
    }

    boolean handleDoubleClick(MouseEvent mouseEvent) {
        if (this.renderer.handleMouseDown(mouseEvent, this.createTextPosition(mouseEvent))) {
            this.updateSizesOnStructChange();
            return true;
        }
        return false;
    }

    void onMouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1) {
            return;
        }
        Point point = this.createTextPosition(mouseEvent);
        if (this.renderer.handleMouseDown(mouseEvent, point)) {
            this.updateSizesOnStructChange();
        } else {
            boolean bl = (mouseEvent.stateMask & SWT.MOD2) != 0;
            this.selectionEnd = bl && this.selectionStart != null ? point : (this.selectionStart = point);
            this.selectionActive = true;
        }
        this.presentation.getControl().redraw();
    }

    void onMouseUp(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = (mouseEvent.stateMask & SWT.MOD2) != 0;
        if (bl) {
            this.selectionEnd = this.createTextPosition(mouseEvent);
        }
        this.selectionActive = false;
    }

    private Point createTextPosition(MouseEvent mouseEvent) {
        if (this.renderer == null) {
            return new Point(mouseEvent.x, mouseEvent.y);
        }
        return new Point((mouseEvent.x + this.presentation.getHorizontalOffset() - 5 - 5) / this.renderer.getCharWidth(), (mouseEvent.y + (this.presentation.getVerticalOffset() - this.topOffset) - 5 - 5 - this.headerHeight) / this.renderer.getLineHeight());
    }

    public void showEditor() throws DBException {
        if (this.editor != null) {
            this.editor.setFocus();
            return;
        }
        if (this.document == null) {
            this.document = this.presentation.createNewDocument();
        }
        Canvas canvas = this.presentation.getControl();
        this.buttonsPanel = new Composite((Composite)canvas, 0x40000000);
        this.buttonsPanel.setLayout((Layout)new RowLayout());
        Button button = new Button(this.buttonsPanel, 8);
        button.setText(ResultsetMessages.DocumentFrame_button_save_text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (DocumentFrame.this.saveEditorChanges()) {
                    DocumentFrame.this.presentation.closeEditor();
                }
            }
        });
        Button button2 = new Button(this.buttonsPanel, 8);
        button2.setText(ResultsetMessages.DocumentFrame_button_cancel_text);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DocumentFrame.this.presentation.closeEditor();
                DocumentFrame.this.presentation.getControl().redraw();
            }
        });
        this.editorFrame = new Composite((Composite)canvas, 0);
        this.editorFrame.setLayout((Layout)new FillLayout());
        this.updateEditorBounds();
        this.editor = this.presentation.createEditor(this.editorFrame, this.document);
        this.presentation.getController().lockActionsByControl((Control)this.editorFrame);
        this.presentation.getController().updateEditControls();
        this.editMode = true;
    }

    private boolean saveEditorChanges() {
        this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
        if (this.document != null) {
            try {
                IEditorInput iEditorInput = this.editor.getEditorInput();
                IStorage iStorage = (IStorage)iEditorInput.getAdapter(IStorage.class);
                if (iStorage == null) {
                    throw new DBException(String.valueOf(ResultsetMessages.DocumentFrame_e_no_storage) + iEditorInput);
                }
                Throwable throwable = null;
                DBDDocument dBDDocument = null;
                try (InputStream inputStream = iStorage.getContents();){
                    this.document.updateDocument((DBRProgressMonitor)new VoidProgressMonitor(), inputStream, "UTF-8");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                throwable = this.presentation.getCurrentAttribute();
                if (throwable == null) {
                    throw new DBException(ResultsetMessages.DocumentFrame_e_no_document_attribute);
                }
                dBDDocument = this.content == null ? this.document : this.content;
                this.presentation.getController().getModel().updateCellValue((DBDAttributeBinding)throwable, this.row, (Object)dBDDocument, true);
                return true;
            }
            catch (Exception exception) {
                DBUserInterface.getInstance().showError(ResultsetMessages.DocumentFrame_e_saving_doc_title, ResultsetMessages.DocumentFrame_e_saving_doc_message, (Throwable)exception);
                return false;
            }
        }
        DBUserInterface.getInstance().showError(ResultsetMessages.DocumentFrame_e_null_doc_title, ResultsetMessages.DocumentFrame_e_null_doc_message);
        return false;
    }

    public void closeEditor() {
        if (this.editMode) {
            if (this.editor != null) {
                this.editor.dispose();
                this.editor = null;
            }
            if (this.editorFrame != null) {
                this.editorFrame.dispose();
                this.editorFrame = null;
            }
            if (this.buttonsPanel != null) {
                this.buttonsPanel.dispose();
                this.buttonsPanel = null;
            }
            this.presentation.getController().updateEditControls();
        }
        this.editMode = false;
        this.presentation.getControl().redraw();
    }

    public void selectAll() {
        this.selectionStart = new Point(0, 0);
        this.selectionEnd = new Point(this.size.x, this.size.y);
    }
}

