/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.core;

import com.dbeaver.ee.runtime.internal.core.EntRuntimeMessages;
import com.dbeaver.lm.core.PublicLicenseValidator;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMEncryption;
import org.jkiss.lm.LMKeyProvider;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMUtils;
import org.jkiss.lm.LMValidateException;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class DBeaverEnterpriseLM {
    public static final LMProduct EE_PRODUCT;
    public static final LMLicenseManager LICENSE_MANAGER;
    private static final Log log;
    public static final String DBEAVER_EE_PRODUCT_ID = "dbeaver-ee";

    static {
        log = Log.getLog(DBeaverEnterpriseLM.class);
        ApplicationDescriptor applicationDescriptor = ApplicationRegistry.getInstance().getApplication();
        Version version = applicationDescriptor.getContributorBundle().getVersion();
        String string = String.valueOf(version.getMajor()) + "." + version.getMinor();
        EE_PRODUCT = new LMProduct(DBEAVER_EE_PRODUCT_ID, "DB", applicationDescriptor.getName(), applicationDescriptor.getDescription(), string, GeneralUtils.getProductReleaseDate());
        LICENSE_MANAGER = new LMLicenseManager((LMKeyProvider)new LicenseKeyProvider(), PublicLicenseValidator.PUBLIC_LICENSE_VALIDATOR);
        String string2 = Platform.getProduct().getProperty("productLicense");
        if (!CommonUtils.isEmpty((String)string2)) {
            try {
                URL uRL = FileLocator.toFileURL((URL)new URL(string2));
                File file = new File(uRL.getFile());
                LMLicenseManager.setLicenseCustomPath((String)file.getAbsolutePath());
            }
            catch (Throwable throwable) {
                log.warn((Object)"Error opening product license", throwable);
            }
        }
    }

    public static boolean hasLicense(String string) {
        try {
            return LICENSE_MANAGER.hasProductLicense(string, EE_PRODUCT);
        }
        catch (LMValidateException lMValidateException) {
            log.debug((Object)("Error validating license: " + lMValidateException.getMessage()));
            return false;
        }
    }

    private static class LicenseKeyProvider
    implements LMKeyProvider {
        LicenseKeyProvider() {
        }

        public Key getEncryptionKey(LMProduct lMProduct) {
            return null;
        }

        public Key getDecryptionKey(LMProduct lMProduct) {
            String string = lMProduct.getId();
            String string2 = "keys/" + string + "-public.key";
            URL uRL = this.getClass().getClassLoader().getResource(string2);
            if (uRL != null) {
                try {
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (InputStream inputStream = uRL.openStream();){
                        byte[] byArray = LMUtils.readEncryptedString((InputStream)inputStream);
                        return LMEncryption.generatePublicKey((byte[])byArray);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    log.error((Object)exception);
                    return null;
                }
            }
            String string3 = NLS.bind((String)EntRuntimeMessages.DBeaverEnterpriseLM_e_key_not_found, (Object)string);
            log.error((Object)string3);
            return null;
        }
    }
}

