/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.model;

import com.dbeaver.ee.redis.RedisUtils;
import com.dbeaver.ee.redis.exec.RedisExecutionContext;
import com.dbeaver.ee.redis.model.RedisDataSourceInfo;
import com.dbeaver.ee.redis.model.RedisDatabase;
import com.dbeaver.ee.redis.model.RedisSQLDialect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerTrustStoreImpl;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleManager;
import org.jkiss.utils.CommonUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisDataSource
implements DBPDataSource,
DBSInstance,
SQLDataSource,
DBSObjectContainer,
DBSObject,
DBSObjectSelector,
DBPRefreshableObject {
    private static final Log log = Log.getLog(RedisDataSource.class);
    @NotNull
    private final DBPDataSourceContainer container;
    @NotNull
    private final JedisPool jedisPool;
    @NotNull
    private RedisExecutionContext executionContext;
    @NotNull
    List<RedisExecutionContext> allContexts = new ArrayList<RedisExecutionContext>();
    private List<RedisDatabase> databases;
    private Long defaultDatabase;
    private RedisDataSourceInfo info;
    private SQLRuleManager commandRuleManager;

    public RedisDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBCException {
        this.container = container;
        DBPConnectionConfiguration connectionInfo = container.getActualConnectionConfiguration();
        String hostName = connectionInfo.getHostName();
        String hostPort = connectionInfo.getHostPort();
        int connectTimeout = CommonUtils.toInt((Object)connectionInfo.getProviderProperty("@dbeaver-redis.timeout.connect"), (int)10000);
        int socketTimeout = CommonUtils.toInt((Object)connectionInfo.getProviderProperty("@dbeaver-redis.timeout.socket"), (int)100000);
        String userPassword = connectionInfo.getUserPassword();
        if (CommonUtils.isEmpty((String)userPassword)) {
            userPassword = null;
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        boolean useSSL = false;
        SSLSocketFactory sslFactory = null;
        SSLParameters sslParameters = null;
        HostnameVerifier hostVerifier = null;
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getDeclaredHandler("redis_ssl");
        if (sslConfig != null && sslConfig.isEnabled()) {
            useSSL = true;
            boolean skipHostValidation = CommonUtils.getBoolean((String)((String)sslConfig.getProperties().get("@dbeaver-redis.ssl.skipHostValidation")), (boolean)false);
            if (skipHostValidation) {
                hostVerifier = (s, sslSession) -> true;
            }
            try {
                SSLHandlerTrustStoreImpl.initializeTrustStore((DBRProgressMonitor)monitor, (DBPDataSource)this, (DBWHandlerConfiguration)sslConfig);
                sslFactory = SSLHandlerTrustStoreImpl.createTrustStoreSslSocketFactory((DBPDataSource)this);
            }
            catch (Exception e) {
                throw new DBCException("Error initializing SSL trust store", (Throwable)e);
            }
            sslParameters = new SSLParameters();
        }
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, hostName, Integer.parseInt(hostPort), connectTimeout, socketTimeout, userPassword, 0, Platform.getProduct().getId(), useSSL, sslFactory, sslParameters, hostVerifier);
        this.executionContext = new RedisExecutionContext(this, "Main Redis Connection");
        this.executionContext.connect(monitor);
        SQLSyntaxManager commandSyntaxManager = new SQLSyntaxManager();
        commandSyntaxManager.init((DBPDataSource)this);
        this.commandRuleManager = new SQLRuleManager(commandSyntaxManager);
        this.commandRuleManager.refreshRules(this.executionContext.getDataSource(), null);
    }

    @NotNull
    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public SQLDialect getSQLDialect() {
        return RedisSQLDialect.INSTANCE;
    }

    @NotNull
    public DBPDataSourceContainer getContainer() {
        return this.container;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.info = new RedisDataSourceInfo(this);
        this.readDatabases();
    }

    private void readDatabases() {
        this.databases = new ArrayList<RedisDatabase>();
        Throwable throwable = null;
        Object var2_3 = null;
        try (Jedis jedis = this.jedisPool.getResource();){
            RedisDatabase database;
            String keySpaceInfo = jedis.info("keyspace");
            try {
                List serverDatabases = jedis.configGet("databases");
                if (serverDatabases != null && serverDatabases.size() == 2) {
                    int dbCount = Integer.parseInt((String)serverDatabases.get(1));
                    int i = 0;
                    while (i < dbCount) {
                        database = new RedisDatabase(this, "db" + i);
                        this.databases.add(database);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                log.debug((Object)"Can't read databases using CONFIG.");
            }
            if (this.databases.isEmpty()) {
                Map<String, String> dbMap = RedisUtils.parseInfo(keySpaceInfo);
                for (Map.Entry<String, String> db : dbMap.entrySet()) {
                    database = new RedisDatabase(this, db.getKey());
                    this.databases.add(database);
                }
            }
            this.defaultDatabase = jedis.getDB();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public DBCExecutionContext getDefaultContext(boolean meta) {
        return this.executionContext;
    }

    @NotNull
    public DBCExecutionContext[] getAllContexts() {
        return this.allContexts.toArray(new DBCExecutionContext[this.allContexts.size()]);
    }

    @NotNull
    public DBCExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose) throws DBException {
        RedisExecutionContext context = new RedisExecutionContext(this, purpose);
        context.connect(monitor);
        return context;
    }

    public void addExecutionContext(RedisExecutionContext context) {
        this.allContexts.add(context);
    }

    public void removeExecutionContext(RedisExecutionContext context) {
        this.allContexts.remove((Object)context);
    }

    public DBSInstance getDefaultInstance() {
        return this;
    }

    public Collection<? extends DBSInstance> getAvailableInstances() {
        return Collections.singletonList(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(DBRProgressMonitor monitor) {
        RedisDataSource redisDataSource = this;
        synchronized (redisDataSource) {
            this.executionContext.close();
            this.jedisPool.close();
        }
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.container;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this;
    }

    @NotNull
    public String getName() {
        return this.container.getName();
    }

    public boolean isPersisted() {
        return true;
    }

    @Association
    public List<RedisDatabase> getDatabases() {
        return this.databases;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.databases;
    }

    public RedisDatabase getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (RedisDatabase)DBUtils.findObject(this.databases, (String)childName);
    }

    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return RedisDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    public String getKeyDivider() {
        String delimiter = this.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-redis.key.divider");
        if (!CommonUtils.isEmpty((String)delimiter)) {
            return delimiter;
        }
        return ":";
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    public RedisDatabase getDefaultObject() {
        for (RedisDatabase db : this.getDatabases()) {
            if (this.defaultDatabase == null || (long)db.getId() != this.defaultDatabase) continue;
            return db;
        }
        return null;
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        RedisDatabase oldSelectedDB = this.getDefaultObject();
        RedisDatabase db = (RedisDatabase)object;
        Throwable throwable = null;
        Object var6_7 = null;
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(db.getId());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.defaultDatabase = db.getId();
        if (oldSelectedDB != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedDB, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)db, (boolean)true);
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        return false;
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        this.readDatabases();
        return this;
    }

    public synchronized String[] parseCommand(String query) {
        Document document = new Document(query);
        this.commandRuleManager.setRange((IDocument)document, 0, query.length());
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder part = new StringBuilder();
        while (true) {
            IToken token;
            if ((token = this.commandRuleManager.nextToken()).isEOF() || token.isWhitespace()) {
                if (part.length() > 0) {
                    parts.add(part.toString());
                    part.setLength(0);
                }
                if (!token.isEOF()) continue;
                break;
            }
            try {
                String tokenText = document.get(this.commandRuleManager.getTokenOffset(), this.commandRuleManager.getTokenLength());
                part.append(tokenText);
            }
            catch (BadLocationException e) {
                log.debug((Object)e);
            }
        }
        return parts.toArray(new String[parts.size()]);
    }
}

