/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.exec;

import com.dbeaver.ee.redis.exec.RedisBaseResultSet;
import com.dbeaver.ee.redis.exec.RedisBaseStatement;
import com.dbeaver.ee.redis.exec.RedisResultSetSimple;
import com.dbeaver.ee.redis.exec.RedisSession;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;

public class RedisEvalStatement
extends RedisBaseStatement {
    protected Object result;

    public RedisEvalStatement(RedisSession session, String query) {
        super(session, query, 0L, 0L);
    }

    public boolean executeStatement() throws DBCException {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        try {
            this.result = this.session.getJedis().eval(this.getQueryString());
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            if (this.session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    public RedisBaseResultSet openResultSet() throws DBCException {
        if (this.result == null) {
            return null;
        }
        return new RedisResultSetSimple(this, this.result, this.offset);
    }
}

