/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.redis.exec;

import com.dbeaver.ee.redis.RedisUtils;
import com.dbeaver.ee.redis.exec.RedisBaseResultSet;
import com.dbeaver.ee.redis.exec.RedisBaseStatement;
import com.dbeaver.ee.redis.exec.RedisResultSetSimple;
import com.dbeaver.ee.redis.exec.RedisSession;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.BeanUtils;
import redis.clients.jedis.Jedis;

public class RedisCommandStatement
extends RedisBaseStatement {
    protected Object result;
    private final String[] command;

    public RedisCommandStatement(RedisSession session, String[] command) {
        super(session, command[0], 0L, 0L);
        this.command = command;
    }

    public boolean executeStatement() throws DBCException {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        try {
            Jedis jedis = this.session.getJedis();
            this.result = this.evaluateCommand(this.command, jedis);
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            if (this.session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    private Object evaluateCommand(String[] command, Jedis jedis) throws DBCException {
        String commandName = command[0].toLowerCase(Locale.ENGLISH);
        Method[] methods = RedisUtils.COMMAND_METHODS.get(commandName);
        if (methods == null) {
            throw new DBCException("Unrecognized command [" + commandName + "]");
        }
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == command.length - 1) {
                Object[] params = new Object[paramTypes.length];
                try {
                    int i = 0;
                    while (i < paramTypes.length) {
                        Class<?> paramType = paramTypes[i];
                        if (paramType.isPrimitive() || BeanUtils.isNumericType(paramType) || BeanUtils.isBooleanType(paramType) || paramType == String.class) {
                            params[i] = GeneralUtils.convertString((String)command[1 + i], paramType);
                        }
                        ++i;
                    }
                    return method.invoke((Object)jedis, params);
                }
                catch (IllegalAccessException e) {
                    throw new DBCException((Throwable)e, (DBPDataSource)this.session.getDataSource());
                }
                catch (InvocationTargetException e) {
                    throw new DBCException(e.getTargetException(), (DBPDataSource)this.session.getDataSource());
                }
            }
            ++n2;
        }
        throw new DBCException("Can't find appropriate method for command '" + commandName + "' (" + (command.length - 1) + ")");
    }

    public RedisBaseResultSet openResultSet() throws DBCException {
        if (this.result == null) {
            return null;
        }
        return new RedisResultSetSimple(this, this.result, (int)this.offset);
    }
}

