/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.model;

import com.dbeaver.ee.qmdb.model.QMDBModel;
import com.dbeaver.ee.qmdb.model.QMDBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class QMDBEventListener
implements QMMetaListener {
    private static final Log log = Log.getLog(QMDBEventListener.class);
    private final QMDBModel model;
    private final PreparedStatement dbStatQueryRead;
    private final PreparedStatement dbStatQueryWrite;
    private final PreparedStatement dbStatEvent;
    private final PreparedStatement dbStatStatement;
    private Map<String, Long> connectionMap = new HashMap<String, Long>();

    public QMDBEventListener(QMDBModel qMDBModel) throws SQLException {
        this.model = qMDBModel;
        this.dbStatQueryRead = qMDBModel.getConnection().prepareStatement("SELECT QUERY_ID,QUERY_TEXT FROM " + qMDBModel.getTableName("QM_QUERY") + " WHERE QUERY_HASH=?");
        this.dbStatQueryWrite = qMDBModel.getConnection().prepareStatement("INSERT INTO " + qMDBModel.getTableName("QM_QUERY") + "(QUERY_HASH,QUERY_TEXT) VALUES(?,?)", 1);
        this.dbStatEvent = qMDBModel.getConnection().prepareStatement("INSERT INTO " + qMDBModel.getTableName("QM_EVENT") + " (CONNECTION_ID,SOURCE_ID,EVENT_ACTION,EVENT_TYPE,EVENT_TIME) VALUES(?,?,?,?,?)", 1);
        this.dbStatStatement = qMDBModel.getConnection().prepareStatement("INSERT INTO " + qMDBModel.getTableName("QM_STATEMENT") + " (STATEMENT_ID,STATEMENT_PURPOSE,QUERY_ID,ROW_COUNT,ERROR_CODE,ERROR_MESSAGE,EXECUTE_TIME,FETCH_TIME) VALUES(?,?,?,?,?,?,?,?)");
    }

    public void dispose() {
        try {
            if (this.dbStatQueryWrite != null) {
                this.dbStatQueryWrite.close();
            }
            if (this.dbStatQueryRead != null) {
                this.dbStatQueryRead.close();
            }
            if (this.dbStatEvent != null) {
                this.dbStatEvent.close();
            }
            if (this.dbStatStatement != null) {
                this.dbStatStatement.close();
            }
        }
        catch (SQLException sQLException) {
            log.debug((Object)sQLException);
        }
    }

    public synchronized void metaInfoChanged(DBRProgressMonitor dBRProgressMonitor, @NotNull List<QMMetaEvent> list) {
        if (this.model.getConnection() == null) {
            return;
        }
        dBRProgressMonitor.beginTask("Persist events", list.size());
        int n = list.size();
        while (n > 0) {
            QMMetaEvent qMMetaEvent = list.get(n - 1);
            dBRProgressMonitor.subTask("Event " + qMMetaEvent.getObject().getObjectId());
            try {
                this.processEvent(qMMetaEvent);
            }
            catch (SQLException sQLException) {
                log.debug((Object)"QMDB error", (Throwable)sQLException);
            }
            dBRProgressMonitor.worked(1);
            --n;
        }
        dBRProgressMonitor.done();
    }

    @NotNull
    private static String makeConnectionKey(QMMSessionInfo qMMSessionInfo) {
        return String.valueOf(qMMSessionInfo.getContainerId()) + ":" + qMMSessionInfo.getContextName();
    }

    private int getEventTypeId(QMMObject qMMObject) {
        Class<?> clazz = qMMObject.getClass();
        if (clazz == QMMSessionInfo.class) {
            return 1;
        }
        if (clazz == QMMTransactionInfo.class) {
            return 2;
        }
        if (clazz == QMMTransactionSavepointInfo.class) {
            return 3;
        }
        if (clazz == QMMStatementInfo.class) {
            return 4;
        }
        if (clazz == QMMStatementExecuteInfo.class) {
            return 5;
        }
        return -1;
    }

    private synchronized void processEvent(QMMetaEvent qMMetaEvent) throws SQLException {
        if (qMMetaEvent.getAction() == QMMetaEvent.Action.UPDATE) {
            return;
        }
        QMMObject qMMObject = qMMetaEvent.getObject();
        if (qMMObject instanceof QMMSessionInfo) {
            if (qMMetaEvent.getAction() == QMMetaEvent.Action.BEGIN) {
                this.createConnectionInfo((QMMSessionInfo)qMMObject);
                this.createConnectionEvent(qMMetaEvent, (QMMSessionInfo)qMMObject, qMMetaEvent.getAction() == QMMetaEvent.Action.BEGIN);
            } else if (qMMetaEvent.getAction() == QMMetaEvent.Action.END) {
                this.createConnectionEvent(qMMetaEvent, (QMMSessionInfo)qMMObject, qMMetaEvent.getAction() == QMMetaEvent.Action.BEGIN);
                this.closeConnectionInfo((QMMSessionInfo)qMMObject);
            }
        } else if (qMMObject instanceof QMMTransactionInfo) {
            this.createTransactionEvent(qMMetaEvent, (QMMTransactionInfo)qMMObject, qMMetaEvent.getAction() == QMMetaEvent.Action.BEGIN);
        } else if (qMMObject instanceof QMMStatementExecuteInfo) {
            this.createStatementEvent(qMMetaEvent, (QMMStatementExecuteInfo)qMMObject);
        }
    }

    private long createConnectionInfo(QMMSessionInfo qMMSessionInfo) throws SQLException {
        Long l = this.connectionMap.get(QMDBEventListener.makeConnectionKey(qMMSessionInfo));
        if (l != null) {
            log.debug((Object)"Connection info already exists. Mixed events?");
            return l;
        }
        Long l2 = this.model.getRunId();
        String string = (String)JDBCUtils.executeQuery((Connection)this.model.getConnection(), (String)("SELECT NAME  FROM " + this.model.getTableName("QM_DATASOURCE") + " WHERE DATASOURCE_ID=?"), (Object[])new Object[]{qMMSessionInfo.getContainerId()});
        if (string == null) {
            JDBCUtils.executeSQL((Connection)this.model.getConnection(), (String)("INSERT INTO " + this.model.getTableName("QM_DATASOURCE") + " (DATASOURCE_ID,NAME,URL,DRIVER,UPDATE_TIME) VALUES(?,?,?,?,?)"), (Object[])new Object[]{qMMSessionInfo.getContainerId(), qMMSessionInfo.getContainerName(), CommonUtils.notEmpty((String)qMMSessionInfo.getConnectionConfiguration().getUrl()), qMMSessionInfo.getDriverId(), new Date()});
        } else {
            JDBCUtils.executeSQL((Connection)this.model.getConnection(), (String)("UPDATE " + this.model.getTableName("QM_DATASOURCE") + " SET NAME=?,URL=?,DRIVER=?,UPDATE_TIME=? WHERE DATASOURCE_ID=?"), (Object[])new Object[]{qMMSessionInfo.getContainerName(), CommonUtils.notEmpty((String)qMMSessionInfo.getConnectionConfiguration().getUrl()), qMMSessionInfo.getDriverId(), new Date(), qMMSessionInfo.getContainerId()});
        }
        l = QMDBUtils.executeInsertAutoIncrement(this.model.getConnection(), "INSERT INTO " + this.model.getTableName("QM_CONNECTION") + " (RUN_ID,DATASOURCE_ID,CONTEXT_NAME,CONNECTION_USER,CONNECT_TIME) VALUES(?,?,?,?,?)", l2, qMMSessionInfo.getContainerId(), CommonUtils.notEmpty((String)qMMSessionInfo.getContextName()), CommonUtils.notEmpty((String)qMMSessionInfo.getConnectionConfiguration().getUserName()), new Date());
        this.connectionMap.put(QMDBEventListener.makeConnectionKey(qMMSessionInfo), l);
        return l;
    }

    private void closeConnectionInfo(QMMSessionInfo qMMSessionInfo) throws SQLException {
        Long l = this.connectionMap.get(QMDBEventListener.makeConnectionKey(qMMSessionInfo));
        if (l == null) {
            log.debug((Object)("Can't find QMDB connection info " + qMMSessionInfo.getContainerId() + " for close"));
            return;
        }
        JDBCUtils.executeSQL((Connection)this.model.getConnection(), (String)("UPDATE " + this.model.getTableName("QM_CONNECTION") + " SET DISCONNECT_TIME=? WHERE CONNECTION_ID=?"), (Object[])new Object[]{new Date(), l});
        this.connectionMap.remove(QMDBEventListener.makeConnectionKey(qMMSessionInfo));
    }

    private long createEventInfo(QMMetaEvent qMMetaEvent, QMMSessionInfo qMMSessionInfo) throws SQLException {
        Long l = this.connectionMap.get(QMDBEventListener.makeConnectionKey(qMMSessionInfo));
        if (l == null) {
            log.debug((Object)("Can't find QMDB connection info " + qMMSessionInfo.getContainerId() + " for event " + qMMetaEvent.getAction() + ". Create new one"));
            l = this.createConnectionInfo(qMMSessionInfo);
        }
        this.dbStatEvent.setLong(1, l);
        this.dbStatEvent.setNull(2, 12);
        this.dbStatEvent.setInt(3, qMMetaEvent.getAction().getId());
        this.dbStatEvent.setInt(4, this.getEventTypeId(qMMetaEvent.getObject()));
        this.dbStatEvent.setTimestamp(5, new Timestamp(qMMetaEvent.getObject().getOpenTime()));
        this.dbStatEvent.execute();
        return QMDBUtils.getGeneratedKey(this.dbStatEvent);
    }

    private void createConnectionEvent(QMMetaEvent qMMetaEvent, QMMSessionInfo qMMSessionInfo, boolean bl) throws SQLException {
        this.createEventInfo(qMMetaEvent, qMMSessionInfo);
    }

    private void createTransactionEvent(QMMetaEvent qMMetaEvent, QMMTransactionInfo qMMTransactionInfo, boolean bl) throws SQLException {
        this.createEventInfo(qMMetaEvent, qMMTransactionInfo.getSession());
    }

    private void createStatementEvent(QMMetaEvent qMMetaEvent, QMMStatementExecuteInfo qMMStatementExecuteInfo) throws SQLException {
        long l = this.createEventInfo(qMMetaEvent, qMMStatementExecuteInfo.getStatement().getSession());
        long l2 = this.getQueryId(qMMStatementExecuteInfo.getQueryString());
        if (qMMetaEvent.getAction() == QMMetaEvent.Action.END) {
            this.dbStatStatement.setLong(1, l);
            this.dbStatStatement.setInt(2, qMMStatementExecuteInfo.getStatement().getPurpose().getId());
            this.dbStatStatement.setLong(3, l2);
            this.dbStatStatement.setLong(4, qMMStatementExecuteInfo.getRowCount());
            this.dbStatStatement.setInt(5, qMMStatementExecuteInfo.getErrorCode());
            if (CommonUtils.isEmpty((String)qMMStatementExecuteInfo.getErrorMessage())) {
                this.dbStatStatement.setNull(6, 12);
            } else {
                this.dbStatStatement.setString(6, qMMStatementExecuteInfo.getErrorMessage());
            }
            this.dbStatStatement.setInt(7, (int)(qMMStatementExecuteInfo.getCloseTime() - qMMStatementExecuteInfo.getOpenTime()));
            long l3 = qMMStatementExecuteInfo.getFetchEndTime();
            this.dbStatStatement.setInt(8, (int)(l3 > 0L ? l3 - qMMStatementExecuteInfo.getFetchBeginTime() : 0L));
            this.dbStatStatement.execute();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getQueryId(String string) throws SQLException {
        long l;
        block10: {
            l = QMDBUtils.getHashCode(string);
            this.dbStatQueryRead.setLong(1, l);
            Throwable throwable = null;
            Object var5_5 = null;
            try {
                ResultSet resultSet;
                block9: {
                    resultSet = this.dbStatQueryRead.executeQuery();
                    finally {
                        if (resultSet.next()) break block9;
                    }
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    break block10;
                }
                String string2 = resultSet.getString(2);
                if (string2.equals(string)) {
                    return resultSet.getLong(1);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        this.dbStatQueryWrite.setLong(1, l);
        this.dbStatQueryWrite.setString(2, string);
        this.dbStatQueryWrite.execute();
        return QMDBUtils.getGeneratedKey(this.dbStatQueryWrite);
    }
}

