/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.model;

import com.dbeaver.ee.mongodb.data.MongoMapValue;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import java.util.Map;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class MGOperation
implements DBAServerSession {
    public static final String CAT_GENERAL = "General";
    public static final String CAT_CLIENT = "Client";
    private final MongoDataSource dataSource;
    private final Map<String, Object> operation;

    public MGOperation(MongoDataSource dataSource, Map<String, Object> operation) {
        this.dataSource = dataSource;
        this.operation = operation;
    }

    @Property(category="General", viewable=true, order=1)
    public Object getId() {
        return this.operation.get("opid");
    }

    @Property(category="General", viewable=true, order=2)
    public String getOperation() {
        return CommonUtils.toString((Object)this.operation.get("op"));
    }

    @Property(category="General", viewable=true, order=3)
    public String getCommand() {
        Object command = this.operation.get("command");
        if (command == null) {
            command = this.operation.get("query");
        }
        if (command instanceof Map) {
            return MongoMapValue.JSON_BUILDER.toJson(command);
        }
        return CommonUtils.toString((Object)command);
    }

    @Property(category="General", viewable=true, order=4)
    public String getHost() {
        return CommonUtils.toString((Object)this.operation.get("host"));
    }

    @Property(category="General", viewable=true, order=5)
    public String getNs() {
        return CommonUtils.toString((Object)this.operation.get("ns"));
    }

    @Property(category="General", viewable=true, multiline=true, order=6)
    public String getDescription() {
        return CommonUtils.toString((Object)this.operation.get("desc"));
    }

    @Property(category="General", viewable=true, order=7)
    public boolean isActive() {
        return CommonUtils.toBoolean((Object)this.operation.get("active"));
    }

    @Property(category="General", viewable=true, order=8)
    public String getCurrentOpTime() {
        return CommonUtils.toString((Object)this.operation.get("currentOpTime"));
    }

    @Property(category="Client", viewable=true, order=30)
    public String getClient() {
        return CommonUtils.toString((Object)this.operation.get("client"));
    }

    @Property(category="Client", viewable=false, order=31)
    public String getAppName() {
        return CommonUtils.toString((Object)this.operation.get("appName"));
    }

    @Property(category="Client", viewable=false, order=32)
    public String getClientMetadata() {
        Object metadata = this.operation.get("clientMetadata");
        if (metadata instanceof Map) {
            return MongoMapValue.JSON_BUILDER.toJson(metadata);
        }
        return CommonUtils.toString((Object)metadata);
    }

    @Property(category="Client", viewable=false, order=33)
    public Number getConnectionId() {
        return (Number)this.operation.get("connectionId");
    }

    public String getActiveQuery() {
        String command = this.getCommand();
        if (CommonUtils.isEmpty((String)command)) {
            command = this.getOperation();
        }
        return command;
    }

    public String toString() {
        return String.valueOf(this.getNs()) + " " + this.getOperation() + " @" + this.getClient();
    }
}

