/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.exec;

import com.dbeaver.ee.mongodb.MongoUtils;
import com.dbeaver.ee.mongodb.exec.MongoBaseStatement;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import com.dbeaver.ee.mongodb.model.MGCollection;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;

public class MongoSelectStatement
extends MongoBaseStatement {
    @Nullable
    private final DBDDataFilter dataFilter;

    public MongoSelectStatement(@NotNull MongoSession mongoSession, @NotNull MGCollection collection, @Nullable DBDDataFilter dataFilter) {
        super(mongoSession, MongoUtils.makeSQLQuery(collection, dataFilter));
        this.collection = collection;
        this.dataFilter = dataFilter;
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            DBObject ref = MongoUtils.makeQueryFromFilter(this.session.getDataSource(), this.dataFilter);
            this.result = this.collection.getCollection().find(ref);
            if (this.dataFilter != null && this.dataFilter.hasOrdering()) {
                BasicDBObject order = new BasicDBObject();
                for (DBDAttributeConstraint constr : this.dataFilter.getOrderConstraints()) {
                    String name = MongoUtils.unquote(DBUtils.getObjectFullName((DBPNamedObject)constr.getAttribute(), (DBPEvaluationContext)DBPEvaluationContext.DML));
                    order.put(name, (Object)(constr.isOrderDescending() ? -1 : 1));
                }
                this.result.sort((DBObject)order);
            }
            return true;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }
}

