/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb;

import com.dbeaver.ee.mongodb.model.MongoDataSource;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class MongoDataSourceProvider
implements DBPDataSourceProvider {
    private static final Log log = Log.getLog(MongoDataSourceProvider.class);

    public MongoDataSourceProvider() {
        Logger mongoLogger = Logger.getLogger("org.mongodb");
        Handler[] oldHandlers = mongoLogger.getHandlers();
        mongoLogger.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                log.debug((Object)("MONGO " + record.getLevel().getName() + ": " + record.getMessage()));
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        mongoLogger.setLevel(Level.WARNING);
    }

    public void init(@NotNull DBPPlatform platform) {
    }

    public long getFeatures() {
        return 2L;
    }

    public DBPPropertyDescriptor[] getConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, DBPConnectionConfiguration connectionInfo) throws DBException {
        return new DBPPropertyDescriptor[]{new PropertyDescriptor("Connection", (Object)"connectTimeout", "Connect Timeout", "The connection timeout in milliseconds.", Long.class, false, null, null, true), new PropertyDescriptor("Connection", (Object)"socketTimeout", "Socket Timeout", "The socket timeout in milliseconds.", Long.class, false, null, null, true), new PropertyDescriptor("Connection", (Object)"socketKeepAlive", "Socket Keep Alive", "This flag controls the socket keep alive feature that keeps a connection alive through firewalls.", Boolean.class, false, null, null, true), new PropertyDescriptor("Connection", (Object)"maxConnectionIdleTime", "Max Connection Idle Time", "The maximum idle time of a pooled connection.", Long.class, false, null, null, true), new PropertyDescriptor("Connection", (Object)"maxConnectionLifeTime", "Max Connection Life Time", "The maximum life time of a pooled connection.", Long.class, false, null, null, true), new PropertyDescriptor("Connection", (Object)"maxWaitTime", "Max Wait Time", "The maximum wait time in milliseconds that a thread may wait for a connection to become available.", Long.class, false, null, null, true), new PropertyDescriptor("Connection", (Object)"singleNodeMode", "Single node mode", "Forces single mode node if there is just one server node configured.\nMakes sense in case of SSH tunnels.", Boolean.class, false, null, null, true), new PropertyDescriptor("Heartbeat", (Object)"heartbeatConnectTimeout", "Heartbeat Connect Timeout", "The connect timeout for connections used for the cluster heartbeat.", Long.class, false, null, null, true), new PropertyDescriptor("Heartbeat", (Object)"heartbeatSocketTimeout", "Heartbeat Socket Timeout", "The socket timeout for connections used for the cluster heartbeat.", Long.class, false, null, null, true), new PropertyDescriptor("Heartbeat", (Object)"heartbeatFrequency", "Heartbeat Frequency", "The heartbeat frequency.", Integer.class, false, null, null, true), new PropertyDescriptor("SSL", (Object)"sslEnabled", "SSL enabled", "SSL protocol enabled.", Boolean.class, false, null, null, true), new PropertyDescriptor("SSL", (Object)"sslInvalidHostNameAllowed", "Invalid host name allowed", "Invalid host name allowed.", Boolean.class, false, null, null, true)};
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        return "mongo://" + connectionInfo.getHostName() + ":" + connectionInfo.getHostPort() + "/" + connectionInfo.getDatabaseName();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new MongoDataSource(monitor, container);
    }
}

