/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.adv.generator.regex;

import com.dbeaver.ee.mockdata.adv.generator.regex.XegerUtils;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.List;
import java.util.Random;

public class Xeger {
    private final Automaton automaton;
    private final Random random;

    public Xeger(String string, Random random) {
        assert (string != null);
        assert (random != null);
        this.automaton = new RegExp(string).toAutomaton();
        this.random = random;
    }

    public Xeger(String string) {
        this(string, new Random());
    }

    public String generate() {
        StringBuilder stringBuilder = new StringBuilder();
        this.generate(stringBuilder, this.automaton.getInitialState());
        return stringBuilder.toString();
    }

    private void generate(StringBuilder stringBuilder, State state) {
        List list = state.getSortedTransitions(true);
        if (list.size() == 0) {
            assert (state.isAccept());
            return;
        }
        int n = state.isAccept() ? list.size() : list.size() - 1;
        int n2 = XegerUtils.getRandomInt(0, n, this.random);
        if (state.isAccept() && n2 == 0) {
            return;
        }
        Transition transition = (Transition)list.get(n2 - (state.isAccept() ? 1 : 0));
        this.appendChoice(stringBuilder, transition);
        this.generate(stringBuilder, transition.getDest());
    }

    private void appendChoice(StringBuilder stringBuilder, Transition transition) {
        char c = (char)XegerUtils.getRandomInt(transition.getMin(), transition.getMax(), this.random);
        stringBuilder.append(c);
    }
}

