/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.adv.generator;

import com.dbeaver.ee.mockdata.adv.generator.StringNameGenerator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mockdata.MockDataUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;

public class StringEmailGenerator
extends StringNameGenerator {
    private static final Log log = Log.getLog(StringEmailGenerator.class);
    private static List<String> MAIL_DOMAINS;
    private static int mailDomains;
    private Random random = new Random();
    private int numericSuffixSize = 2;

    @Override
    public void init(DBSDataManipulator dBSDataManipulator, DBSAttributeBase dBSAttributeBase, Map<Object, Object> map) throws DBException {
        super.init(dBSDataManipulator, dBSAttributeBase, map);
        Integer n = (Integer)map.get("numericSuffixSize");
        if (n != null) {
            this.numericSuffixSize = n;
        }
    }

    @Override
    public Object generateOneValue(DBRProgressMonitor dBRProgressMonitor) throws DBException, IOException {
        Object object;
        if (mailDomains == 0) {
            MAIL_DOMAINS = this.readDict("mail_domains.txt");
            mailDomains = MAIL_DOMAINS.size();
        }
        if ((object = super.generateOneValue(dBRProgressMonitor)) == null) {
            return null;
        }
        String string = (String)object;
        if (this.numericSuffixSize > 0) {
            string = String.valueOf(string) + String.format(".%0" + this.numericSuffixSize + "d", MockDataUtils.getRandomInt((int)0, (int)MockDataUtils.degree((int)this.numericSuffixSize), (Random)this.random));
        }
        String string2 = "@" + MAIL_DOMAINS.get(this.random.nextInt(mailDomains));
        if (this.withSurnames) {
            return String.valueOf(string.replace(' ', '.')) + string2;
        }
        return String.valueOf(string) + string2;
    }
}

