/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.views;

import com.dbeaver.ee.influxdb.exec.InfluxExecutionContext;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.influxdb.InfluxDB;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;

public class InfluxConsistencyLevelContributor
extends DataSourceMenuContributor {
    protected void fillContributionItems(List<IContributionItem> list) {
        DBCExecutionContext dBCExecutionContext;
        IWorkbenchWindow iWorkbenchWindow = UIUtils.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return;
        }
        IEditorPart iEditorPart = iWorkbenchWindow.getActivePage().getActiveEditor();
        if (iEditorPart instanceof DBPContextProvider && (dBCExecutionContext = ((DBPContextProvider)iEditorPart).getExecutionContext()) instanceof InfluxExecutionContext) {
            InfluxDB.ConsistencyLevel consistencyLevel = ((InfluxExecutionContext)dBCExecutionContext).getCurrentConsistencyLevel();
            InfluxDB.ConsistencyLevel[] consistencyLevelArray = InfluxDB.ConsistencyLevel.values();
            int n = consistencyLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                InfluxDB.ConsistencyLevel consistencyLevel2 = consistencyLevelArray[n2];
                list.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new ConsistencyLevelAction((InfluxExecutionContext)dBCExecutionContext, consistencyLevel2, consistencyLevel2.equals((Object)consistencyLevel)), (boolean)true));
                ++n2;
            }
        }
    }

    private static class ConsistencyLevelAction
    extends Action {
        private final InfluxExecutionContext executionContext;
        private final InfluxDB.ConsistencyLevel level;
        private final boolean checked;

        public ConsistencyLevelAction(InfluxExecutionContext influxExecutionContext, InfluxDB.ConsistencyLevel consistencyLevel, boolean bl) {
            this.executionContext = influxExecutionContext;
            this.level = consistencyLevel;
            this.checked = bl;
        }

        public int getStyle() {
            return 8;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public String getText() {
            return this.level.name();
        }

        public void run() {
            this.executionContext.setCurrentConsistencyLevel(this.level);
        }
    }
}

