/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.exec;

import com.dbeaver.ee.influxdb.exec.InfluxBaseStatement;
import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import java.util.Collection;
import java.util.Locale;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;

public class InfluxSelectStatement
extends InfluxBaseStatement {
    private static final Log log = Log.getLog(InfluxSelectStatement.class);

    public InfluxSelectStatement(InfluxSession influxSession, InfluxDatabase influxDatabase, String string) {
        super(influxSession, influxDatabase, string);
    }

    public boolean executeStatement() throws DBCException {
        String string = this.getQueryString();
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = SQLUtils.getFirstKeyword((SQLDialect)this.session.getDataSource().getSQLDialect(), (String)string2);
        if (string3.equals("select") && this.getLimit() > 0 && !string2.contains("limit")) {
            string = String.valueOf(string) + " LIMIT " + this.getLimit();
            if (this.getOffset() > 0 && !string2.contains("offset")) {
                string = String.valueOf(string) + " OFFSET " + this.getOffset();
            }
        }
        this.beforeExecute();
        try {
            InfluxDatabase influxDatabase = this.getCurrentDatabase();
            if (influxDatabase == null) {
                throw new DBCException("Can't execute query - no active database");
            }
            InfluxDB influxDB = this.getSession().getInfluxDB();
            QueryResult queryResult = influxDB.query(new Query(string, influxDatabase.getName()));
            if (queryResult == null || CommonUtils.isEmpty((Collection)queryResult.getResults())) {
                this.setQueryResult(null);
                return false;
            }
            QueryResult.Result result = (QueryResult.Result)queryResult.getResults().get(0);
            if (!CommonUtils.isEmpty((String)result.getError())) {
                throw new DBCException("InfluxDB error: " + result.getError());
            }
            if (CommonUtils.isEmpty((Collection)result.getSeries())) {
                this.setQueryResult(null);
                return false;
            }
            this.setQueryResult(queryResult);
            return true;
        }
        catch (Throwable throwable) {
            throw this.handleExecuteError(throwable);
        }
        finally {
            this.afterExecute();
        }
    }
}

