/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.exec;

import com.dbeaver.ee.influxdb.exec.InfluxResultSet;
import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import java.util.List;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class InfluxBaseStatement
implements DBCStatement {
    private static final Log log = Log.getLog(InfluxBaseStatement.class);
    protected final InfluxSession session;
    protected final InfluxDatabase database;
    protected final String query;
    protected DBCExecutionSource source;
    protected QueryResult queryResult;
    protected int curResultsIndex;
    protected int curSeriesIndex;
    protected Throwable executeError;
    protected int offset;
    protected int limit;

    protected InfluxBaseStatement(InfluxSession influxSession, InfluxDatabase influxDatabase, String string) {
        this.session = influxSession;
        this.database = influxDatabase;
        this.query = string;
        if (influxSession.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    public InfluxDatabase getCurrentDatabase() {
        return this.database != null ? this.database : this.getSession().getDataSource().getDefaultObject();
    }

    @NotNull
    public InfluxSession getSession() {
        return this.session;
    }

    public String getQueryString() {
        return this.query;
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource dBCExecutionSource) {
        this.source = dBCExecutionSource;
    }

    public void addToBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public InfluxResultSet openResultSet() throws DBCException {
        QueryResult.Result result = (QueryResult.Result)this.queryResult.getResults().get(this.curResultsIndex);
        return new InfluxResultSet(this, result.getSeries() == null ? null : (QueryResult.Series)result.getSeries().get(this.curSeriesIndex));
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int getUpdateRowCount() {
        return -1;
    }

    public boolean nextResults() throws DBCException {
        List list;
        List list2 = this.queryResult.getResults();
        if (list2.size() > this.curResultsIndex && (list = ((QueryResult.Result)list2.get(this.curResultsIndex)).getSeries()) != null && list.size() > this.curSeriesIndex + 1) {
            ++this.curSeriesIndex;
            return true;
        }
        if (list2.size() > this.curResultsIndex + 1) {
            ++this.curResultsIndex;
            this.curSeriesIndex = 0;
            return true;
        }
        return false;
    }

    public void close() {
        this.queryResult = null;
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, (long)this.getUpdateRowCount());
        }
    }

    public void setLimit(long l, long l2) throws DBCException {
        this.offset = (int)l;
        this.limit = (int)l2;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int n) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable Thread thread) throws DBException {
        if (thread == null) {
            throw new DBException("Mongo query cancel not implemented");
        }
        thread.interrupt();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    protected DBCException handleExecuteError(Throwable throwable) {
        this.executeError = throwable;
        if (throwable instanceof DBCException) {
            return (DBCException)throwable;
        }
        return new DBCException(throwable, (DBPDataSource)this.session.getDataSource());
    }

    protected void beforeExecute() {
        this.executeError = null;
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock();
    }

    protected void afterExecute() {
        this.endBlock();
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, (long)this.getUpdateRowCount(), this.executeError);
        }
    }

    protected void startBlock() {
        this.session.getProgressMonitor().startBlock((DBRBlockingObject)this, this.getClass().getSimpleName());
    }

    protected void endBlock() {
        this.session.getProgressMonitor().endBlock();
    }

    protected void setQueryResult(QueryResult queryResult) {
        this.queryResult = queryResult;
    }
}

