/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.chart.model;

import java.util.List;

public enum ChartSampleFunction {
    AVG{

        @Override
        public Number execute(List<Number> list) {
            return list.isEmpty() ? 0.0 : SUM.execute(list).doubleValue() / (double)list.size();
        }
    }
    ,
    SUM{

        @Override
        public Number execute(List<Number> list) {
            double d = 0.0;
            for (Number number : list) {
                d += number.doubleValue();
            }
            return d;
        }
    }
    ,
    FIRST{

        @Override
        public Number execute(List<Number> list) {
            return list.isEmpty() ? (Number)0.0 : (Number)list.get(0);
        }
    }
    ,
    LAST{

        @Override
        public Number execute(List<Number> list) {
            return list.isEmpty() ? (Number)0.0 : (Number)list.get(list.size() - 1);
        }
    }
    ,
    MIN{

        @Override
        public Number execute(List<Number> list) {
            double d = Double.NaN;
            for (Number number : list) {
                double d2 = d = Double.isNaN(d) ? number.doubleValue() : Math.min(d, number.doubleValue());
            }
            return d;
        }
    }
    ,
    MAX{

        @Override
        public Number execute(List<Number> list) {
            double d = Double.NaN;
            for (Number number : list) {
                double d2 = d = Double.isNaN(d) ? number.doubleValue() : Math.max(d, number.doubleValue());
            }
            return d;
        }
    }
    ,
    COUNT{

        @Override
        public Number execute(List<Number> list) {
            return list.size();
        }
    };


    private ChartSampleFunction() {
    }

    public abstract Number execute(List<Number> var1);

    /* synthetic */ ChartSampleFunction(String string, int n, ChartSampleFunction chartSampleFunction) {
        this();
    }
}

