/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.chart.model;

import com.dbeaver.ee.chart.model.ChartSampleFunction;
import com.dbeaver.ee.chart.model.ChartValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSConstraintEnumerable;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.data.editors.ReferenceValueEditor;
import org.jkiss.utils.CommonUtils;

public class ChartMeasurement {
    public static final int DEFAULT_MAX_SAMPLE_COUNT = 50;
    private static final Log log = Log.getLog(ChartMeasurement.class);
    private String title;
    private String titleX;
    private String titleY;
    private boolean useDictionaries;
    private List<DBDAttributeBinding> groupAttributes;
    private DBDAttributeBinding valueAttribute;
    private List<ChartValue> values = new ArrayList<ChartValue>();
    private int maxRowCount = 0;
    private int maxSampleCount = 50;
    private ChartSampleFunction sampleFunction = ChartSampleFunction.SUM;

    public ChartMeasurement() {
        this.groupAttributes = new ArrayList<DBDAttributeBinding>();
        this.valueAttribute = null;
    }

    public ChartMeasurement(ChartMeasurement chartMeasurement) {
        this.title = chartMeasurement.title;
        this.titleX = chartMeasurement.titleX;
        this.titleY = chartMeasurement.titleY;
        this.useDictionaries = chartMeasurement.useDictionaries;
        this.maxRowCount = chartMeasurement.maxRowCount;
        this.maxSampleCount = chartMeasurement.maxSampleCount;
        this.sampleFunction = chartMeasurement.sampleFunction;
        this.groupAttributes = new ArrayList<DBDAttributeBinding>(chartMeasurement.groupAttributes);
        this.valueAttribute = chartMeasurement.valueAttribute;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitleX() {
        return this.titleX;
    }

    public void setTitleX(String string) {
        this.titleX = string;
    }

    public String getTitleY() {
        return this.titleY;
    }

    public void setTitleY(String string) {
        this.titleY = string;
    }

    public boolean isUseDictionaries() {
        return this.useDictionaries;
    }

    public void setUseDictionaries(boolean bl) {
        this.useDictionaries = bl;
    }

    public List<DBDAttributeBinding> getGroupAttributes() {
        return this.groupAttributes;
    }

    public void setGroupAttributes(List<DBDAttributeBinding> list) {
        this.groupAttributes = list;
    }

    public DBDAttributeBinding getValueAttribute() {
        return this.valueAttribute;
    }

    public void setValueAttribute(DBDAttributeBinding dBDAttributeBinding) {
        this.valueAttribute = dBDAttributeBinding;
    }

    public List<ChartValue> getValues() {
        return this.values;
    }

    public void setValues(List<ChartValue> list) {
        this.values = list;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public void setMaxRowCount(int n) {
        this.maxRowCount = n;
    }

    public int getMaxSampleCount() {
        return this.maxSampleCount;
    }

    public void setMaxSampleCount(int n) {
        this.maxSampleCount = n;
    }

    public ChartSampleFunction getSampleFunction() {
        return this.sampleFunction;
    }

    public void setSampleFunction(ChartSampleFunction chartSampleFunction) {
        this.sampleFunction = chartSampleFunction;
    }

    /*
     * WARNING - void declaration
     */
    public void loadDataFromModel(DBRProgressMonitor dBRProgressMonitor, IResultSetController iResultSetController) {
        void var6_13;
        Collection<Object> collection;
        Object object;
        Serializable serializable;
        ResultSetModel resultSetModel = iResultSetController.getModel();
        int n = resultSetModel.getRowCount();
        this.values = new ArrayList<ChartValue>();
        IdentityHashMap<DBDAttributeBinding, Set<Object>> identityHashMap = new IdentityHashMap<DBDAttributeBinding, Set<Object>>();
        if (this.useDictionaries) {
            for (DBDAttributeBinding object3 : this.groupAttributes) {
                DBSConstraintEnumerable dBSConstraintEnumerable;
                serializable = ReferenceValueEditor.getEnumerableConstraint((DBDAttributeBinding)object3);
                if (serializable == null || (dBSConstraintEnumerable = (DBSConstraintEnumerable)((DBSEntityAssociation)serializable).getReferencedConstraint()) == null) continue;
                try {
                    object = serializable.getAttributeReferences(dBRProgressMonitor);
                    if (CommonUtils.isEmpty((Collection)object)) continue;
                    collection = new AttrDictInfo();
                    ((AttrDictInfo)((Object)collection)).refConstraint = dBSConstraintEnumerable;
                    DBSEntityAttribute dBSEntityAttribute = DBUtils.getReferenceAttribute((DBRProgressMonitor)dBRProgressMonitor, (DBSEntityAssociation)((DBSEntityAssociation)serializable), (DBSEntityAttribute)object3.getEntityAttribute(), (boolean)false);
                    if (dBSEntityAttribute != null) {
                        ((AttrDictInfo)((Object)collection)).refAttr = dBSEntityAttribute;
                        identityHashMap.put(object3, (Set<Object>)collection);
                        continue;
                    }
                    log.debug((Object)("Can't get ref attribute for title attribute " + object3.getFullyQualifiedName(DBPEvaluationContext.UI)));
                }
                catch (DBException dBException) {
                    log.debug((Object)"Error reading reference columns", (Throwable)dBException);
                }
            }
            if (!identityHashMap.isEmpty()) {
                block10: for (Map.Entry entry : identityHashMap.entrySet()) {
                    int n2 = 0;
                    while (n2 < n) {
                        ResultSetRow resultSetRow = resultSetModel.getRow(n2);
                        object = resultSetModel.getCellValue((DBDAttributeBinding)entry.getKey(), resultSetRow);
                        collection = ((AttrDictInfo)entry.getValue()).keyValues;
                        collection.add(object);
                        if (this.maxRowCount > 0 && collection.size() >= this.maxRowCount) continue block10;
                        ++n2;
                    }
                }
                for (Map.Entry entry : identityHashMap.entrySet()) {
                    if (((AttrDictInfo)entry.getValue()).keyValues.isEmpty()) continue;
                    try {
                        serializable = null;
                        Object var9_22 = null;
                        try {
                            object = iResultSetController.getExecutionContext().openSession(dBRProgressMonitor, DBCExecutionPurpose.UTIL, "Load key dictionary labels");
                            try {
                                collection = ((AttrDictInfo)entry.getValue()).refConstraint.getKeyEnumeration((DBCSession)object, ((AttrDictInfo)entry.getValue()).refAttr, new ArrayList<Object>(((AttrDictInfo)entry.getValue()).keyValues), null, true, false);
                                for (DBDLabelValuePair dBDLabelValuePair : collection) {
                                    ((AttrDictInfo)entry.getValue()).keyLabels.put(dBDLabelValuePair.getValue(), dBDLabelValuePair.getLabel());
                                }
                            }
                            finally {
                                if (object != null) {
                                    object.close();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            if (serializable == null) {
                                serializable = throwable;
                            } else if (serializable != throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                            throw serializable;
                        }
                    }
                    catch (DBException dBException) {
                        log.debug((Object)"Error reading dictionary labels", (Throwable)dBException);
                    }
                }
            }
        }
        boolean bl = false;
        while (var6_13 < n) {
            ResultSetRow resultSetRow = resultSetModel.getRow((int)var6_13);
            serializable = new StringBuilder();
            for (DBDAttributeBinding dBDAttributeBinding : this.groupAttributes) {
                Object object2;
                collection = resultSetModel.getCellValue(dBDAttributeBinding, resultSetRow);
                AttrDictInfo attrDictInfo = (AttrDictInfo)identityHashMap.get(dBDAttributeBinding);
                if (attrDictInfo != null) {
                    object2 = attrDictInfo.keyLabels.get(collection);
                    if (object2 != null) {
                        ((StringBuilder)serializable).append((String)object2);
                        continue;
                    }
                    ((StringBuilder)serializable).append(collection);
                    continue;
                }
                object2 = dBDAttributeBinding.getValueHandler().getValueDisplayString((DBSTypedObject)dBDAttributeBinding.getAttribute(), collection, DBDDisplayFormat.UI);
                ((StringBuilder)serializable).append((String)object2);
            }
            Object object3 = resultSetModel.getCellValue(this.valueAttribute, resultSetRow);
            if (object3 instanceof Number) {
                object = new ChartValue(((StringBuilder)serializable).toString(), (Number)object3);
                this.values.add((ChartValue)object);
            }
            ++var6_13;
        }
    }

    static class AttrDictInfo {
        DBSConstraintEnumerable refConstraint;
        Set<Object> keyValues = new LinkedHashSet<Object>();
        Map<Object, String> keyLabels = new HashMap<Object, String>();
        public DBSEntityAttribute refAttr;

        AttrDictInfo() {
        }
    }
}

