/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.views;

import com.datastax.driver.core.ConsistencyLevel;
import com.dbeaver.ee.cassandra.Activator;
import com.dbeaver.ee.cassandra.views.CasSocketSettingsPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageNetwork;
import org.jkiss.utils.CommonUtils;

public class CasConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private static ImageDescriptor logoImage = Activator.getImageDescriptor("icons/cassandra_logo.png");
    private Text hostText;
    private Text portText;
    private Text keyspaceText;
    private Text userNameText;
    private Text passwordText;
    private Button useSslButton;
    private Button enableQueryTraceButton;
    private Combo defConsistencyLevel;
    private boolean activated;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        this.setControl((Control)this.createGeneralTab(composite));
    }

    private Composite createGeneralTab(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        Composite configGroup = new Composite(parent, 0);
        configGroup.setLayout((Layout)new GridLayout(1, false));
        configGroup.setLayoutData((Object)new GridData(1808));
        Group settingsGroup = UIUtils.createControlGroup((Composite)configGroup, (String)"Connection Setting", (int)4, (int)768, (int)0);
        this.hostText = UIUtils.createLabelText((Composite)settingsGroup, (String)"Host(s)", (String)"", (int)2048);
        this.hostText.setToolTipText("Contact point(s). Divide multiple host names with comma.\nNote: if you use a tunnel then only first host connection will be forwarded.");
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        this.keyspaceText = UIUtils.createLabelText((Composite)settingsGroup, (String)"Keyspace", (String)"", (int)2048);
        this.keyspaceText.setLayoutData((Object)new GridData(768));
        this.keyspaceText.addModifyListener(textListener);
        this.portText = UIUtils.createLabelText((Composite)settingsGroup, (String)"Port", (String)"", (int)2048);
        gd = new GridData(2);
        gd.widthHint = 60;
        this.portText.setLayoutData((Object)gd);
        this.portText.addModifyListener(textListener);
        this.userNameText = UIUtils.createLabelText((Composite)settingsGroup, (String)"User", (String)"", (int)2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.userNameText.setLayoutData((Object)gd);
        this.userNameText.addModifyListener(textListener);
        UIUtils.createEmptyLabel((Composite)settingsGroup, (int)2, (int)1);
        this.passwordText = UIUtils.createLabelText((Composite)settingsGroup, (String)"Password", (String)"", (int)0x400800);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener(textListener);
        this.createSavePasswordButton((Composite)settingsGroup, 2);
        this.useSslButton = UIUtils.createCheckbox((Composite)settingsGroup, (String)"Use SSL", (String)"Enable SSL connection (server must be configured to support SSL)", (boolean)true, (int)1);
        Link sslLink = new Link((Composite)settingsGroup, 0);
        sslLink.setText("<a>SSL settings</a>");
        sslLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CasConnectionPage.this.site.openSettingsPage(ConnectionPageNetwork.PAGE_NAME);
            }
        });
        GridData gd2 = new GridData(32);
        sslLink.setLayoutData((Object)gd2);
        UIUtils.createEmptyLabel((Composite)settingsGroup, (int)2, (int)1);
        Group miscGroup = UIUtils.createControlGroup((Composite)configGroup, (String)"Misc", (int)2, (int)768, (int)0);
        this.enableQueryTraceButton = UIUtils.createCheckbox((Composite)settingsGroup, (String)"Enable query tracing", (String)"Enable CQL queries trace (available in results Trace panel)", (boolean)true, (int)2);
        this.defConsistencyLevel = UIUtils.createLabelCombo((Composite)miscGroup, (String)"Default consistency level", (String)"Default consistencty level for queries", (int)12);
        ConsistencyLevel[] consistencyLevelArray = ConsistencyLevel.values();
        int n = consistencyLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConsistencyLevel cl = consistencyLevelArray[n2];
            this.defConsistencyLevel.add(cl.name());
            ++n2;
        }
        this.createDriverPanel(configGroup);
        return configGroup;
    }

    public boolean isComplete() {
        return !this.hostText.getText().isEmpty() && !this.keyspaceText.getText().isEmpty();
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            String hostName = !CommonUtils.isEmpty((String)connectionInfo.getHostName()) ? connectionInfo.getHostName() : "localhost";
            String extraCP = connectionInfo.getProviderProperty("@dbeaver-connection.points@");
            if (!CommonUtils.isEmpty((String)extraCP)) {
                hostName = String.valueOf(hostName) + "," + extraCP;
            }
            this.hostText.setText(CommonUtils.notEmpty((String)hostName));
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.keyspaceText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                this.keyspaceText.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
            } else {
                this.keyspaceText.setText("system");
            }
        }
        if (this.userNameText != null) {
            this.userNameText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        }
        boolean useSSL = CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-ssl@"));
        this.useSslButton.setSelection(useSSL);
        boolean useQueryTrace = CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-enable.query.trace@"));
        this.enableQueryTraceButton.setSelection(useQueryTrace);
        String clName = CommonUtils.toString((Object)connectionInfo.getProviderProperty("@dbeaver-default.consistency.level@"));
        if (CommonUtils.isEmpty((String)clName)) {
            this.defConsistencyLevel.setText(ConsistencyLevel.ONE.name());
        } else {
            this.defConsistencyLevel.setText(clName);
        }
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            String hostNames = this.hostText.getText().trim();
            int divPos = hostNames.indexOf(",");
            if (divPos != -1) {
                connectionInfo.setProviderProperty("@dbeaver-connection.points@", hostNames.substring(divPos + 1).trim());
                hostNames = hostNames.substring(0, divPos).trim();
            } else {
                connectionInfo.removeProviderProperty("@dbeaver-connection.points@");
            }
            connectionInfo.setHostName(hostNames);
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.keyspaceText != null) {
            connectionInfo.setDatabaseName(this.keyspaceText.getText().trim());
        }
        if (this.userNameText != null) {
            connectionInfo.setUserName(this.userNameText.getText().trim());
        }
        if (this.passwordText != null) {
            connectionInfo.setUserPassword(this.passwordText.getText());
        }
        connectionInfo.setProviderProperty("@dbeaver-ssl@", String.valueOf(this.useSslButton.getSelection()));
        connectionInfo.setProviderProperty("@dbeaver-enable.query.trace@", String.valueOf(this.enableQueryTraceButton.getSelection()));
        connectionInfo.setProviderProperty("@dbeaver-default.consistency.level@", String.valueOf(this.defConsistencyLevel.getText()));
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getSubPages() {
        return new IDialogPage[]{new CasSocketSettingsPage()};
    }
}

