/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import com.dbeaver.ee.cassandra.CasUtils;
import com.dbeaver.ee.cassandra.exec.CasBaseStatement;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasKeyspace;
import com.dbeaver.ee.cassandra.model.CasTable;
import com.dbeaver.ee.cassandra.model.CasTypedObject;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;

public class CasResultSetMetaData
implements DBCResultSetMetaData {
    private static final Log log = Log.getLog(CasResultSetMetaData.class);
    private final CasBaseStatement sourceStatement;
    private final List<DBCAttributeMetaData> columns;

    public CasResultSetMetaData(CasBaseStatement casBaseStatement, ResultSet resultSet) {
        this.sourceStatement = casBaseStatement;
        List list = resultSet.getColumnDefinitions().asList();
        this.columns = new ArrayList<DBCAttributeMetaData>(list.size());
        int n = 0;
        while (n < list.size()) {
            ColumnDefinitions.Definition definition = (ColumnDefinitions.Definition)list.get(n);
            this.columns.add(new ColumnMetaData(definition, n));
            ++n;
        }
    }

    public List<DBCAttributeMetaData> getAttributes() {
        return this.columns;
    }

    CasTable getOwnTable(ColumnDefinitions.Definition definition) {
        CasDataSource casDataSource = this.sourceStatement.getSession().getDataSource();
        CasKeyspace casKeyspace = casDataSource.getKeyspace(definition.getKeyspace());
        if (casKeyspace != null) {
            try {
                return casKeyspace.getChild((DBRProgressMonitor)new VoidProgressMonitor(), definition.getTable());
            }
            catch (DBException dBException) {
                log.error((Object)dBException);
            }
        }
        return null;
    }

    public class ColumnMetaData
    implements DBCAttributeMetaData,
    CasTypedObject {
        private final ColumnDefinitions.Definition definition;
        private final int position;

        private ColumnMetaData(ColumnDefinitions.Definition definition, int n) {
            this.definition = definition;
            this.position = n;
        }

        public Object getSource() {
            return CasResultSetMetaData.this.sourceStatement.getStatementSource();
        }

        @NotNull
        public String getLabel() {
            return this.definition.getName();
        }

        public String getEntityName() {
            return null;
        }

        @Property
        public boolean isReadOnly() {
            return false;
        }

        public DBCEntityMetaData getEntityMetaData() {
            return null;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        @Property(viewable=true, order=1)
        @NotNull
        public String getName() {
            return this.definition.getName();
        }

        @Property(viewable=true, order=2)
        public int getOrdinalPosition() {
            return this.position;
        }

        @Override
        @Property(viewable=true, order=3)
        @NotNull
        public DataType getCasDataType() {
            return this.definition.getType();
        }

        @Property(viewable=true, order=5)
        public boolean isRequired() {
            DBPDataKind dBPDataKind = this.getDataKind();
            return dBPDataKind == DBPDataKind.NUMERIC || dBPDataKind == DBPDataKind.BOOLEAN;
        }

        public String getTypeName() {
            return this.definition.getType().getName().toString();
        }

        public String getFullTypeName() {
            return this.getTypeName();
        }

        public int getTypeID() {
            return CasUtils.getTypeNameID(this.definition.getType());
        }

        public DBPDataKind getDataKind() {
            return CasUtils.getDataKind(this.definition.getType());
        }

        public Integer getScale() {
            return 0;
        }

        public Integer getPrecision() {
            return 0;
        }

        public long getMaxLength() {
            return 0L;
        }

        public String toString() {
            return String.valueOf(this.getName()) + " " + this.getFullTypeName();
        }
    }
}

