/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.AggregateMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UserType;
import com.dbeaver.ee.cassandra.model.CasAggregate;
import com.dbeaver.ee.cassandra.model.CasCQLObject;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasFunction;
import com.dbeaver.ee.cassandra.model.CasMView;
import com.dbeaver.ee.cassandra.model.CasTable;
import com.dbeaver.ee.cassandra.model.CasUserType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.AbstractObjectCache;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class CasKeyspace
implements DBSCatalog,
CasCQLObject,
DBPSystemObject,
DBPRefreshableObject {
    private final CasDataSource dataSource;
    private final KeyspaceMetadata metadata;
    private final TableCache tableCache = new TableCache();
    private final MaterializedViewCache mviewsCache = new MaterializedViewCache();
    private final UserTypeCache userTypeCache = new UserTypeCache();
    private final AggregateCache aggregateCache = new AggregateCache();
    private final FunctionCache functionCache = new FunctionCache();

    public CasKeyspace(CasDataSource casDataSource, KeyspaceMetadata keyspaceMetadata) {
        this.dataSource = casDataSource;
        this.metadata = keyspaceMetadata;
    }

    @NotNull
    public CasDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.metadata.getName();
    }

    @Property
    public boolean isDurableWrites() {
        return this.metadata.isDurableWrites();
    }

    @Property
    public Map<String, String> getReplicationStrategy() {
        return this.metadata.getReplication();
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return true;
    }

    @Association
    public Collection<CasTable> getTables(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.tableCache.getAllObjects(dBRProgressMonitor, this);
    }

    @Association
    public Collection<CasMView> getMaterializedViews(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.mviewsCache.getAllObjects(dBRProgressMonitor, this);
    }

    @Association
    public Collection<CasUserType> getUserTypes(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.userTypeCache.getAllObjects(dBRProgressMonitor, this);
    }

    public CasUserType getUserType(DBRProgressMonitor dBRProgressMonitor, DataType dataType) throws DBException {
        for (CasUserType casUserType : this.userTypeCache.getAllObjects(dBRProgressMonitor, this)) {
            if (!casUserType.getCasDataType().equals(dataType)) continue;
            return casUserType;
        }
        return null;
    }

    @Association
    public Collection<CasAggregate> getAggregates(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.aggregateCache.getAllObjects(dBRProgressMonitor, this);
    }

    @Association
    public Collection<CasFunction> getFunctions(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.functionCache.getAllObjects(dBRProgressMonitor, this);
    }

    public Collection<CasTable> getChildren(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.tableCache.getAllObjects(dBRProgressMonitor, this);
    }

    public CasTable getChild(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull String string) throws DBException {
        return this.tableCache.getObject(dBRProgressMonitor, this, string);
    }

    public Class<CasTable> getChildType(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return CasTable.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor dBRProgressMonitor, int n) throws DBException {
        this.tableCache.getAllObjects(dBRProgressMonitor, this);
    }

    public String getObjectDefinitionText(DBRProgressMonitor dBRProgressMonitor, Map<String, Object> map) {
        return this.metadata.exportAsString();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        this.tableCache.clearCache();
        this.mviewsCache.clearCache();
        this.userTypeCache.clearCache();
        this.aggregateCache.clearCache();
        this.functionCache.clearCache();
        return this;
    }

    public boolean isSystem() {
        String string = this.getName();
        return string.equals("system") || string.startsWith("system_");
    }

    class AggregateCache
    extends AbstractObjectCache<CasKeyspace, CasAggregate> {
        AggregateCache() {
        }

        @NotNull
        public Collection<CasAggregate> getAllObjects(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasAggregate> arrayList = new ArrayList<CasAggregate>();
                for (AggregateMetadata aggregateMetadata : CasKeyspace.this.metadata.getAggregates()) {
                    arrayList.add(new CasAggregate(casKeyspace, aggregateMetadata));
                    if (dBRProgressMonitor.isCanceled()) break;
                }
                this.setCache(arrayList);
            }
            return this.getCachedObjects();
        }

        public CasAggregate getObject(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable CasKeyspace casKeyspace, @NotNull String string) throws DBException {
            return (CasAggregate)DBUtils.findObject(this.getAllObjects(dBRProgressMonitor, casKeyspace), (String)string);
        }
    }

    class FunctionCache
    extends AbstractObjectCache<CasKeyspace, CasFunction> {
        FunctionCache() {
        }

        @NotNull
        public Collection<CasFunction> getAllObjects(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasFunction> arrayList = new ArrayList<CasFunction>();
                for (FunctionMetadata functionMetadata : CasKeyspace.this.metadata.getFunctions()) {
                    arrayList.add(new CasFunction(casKeyspace, functionMetadata));
                    if (dBRProgressMonitor.isCanceled()) break;
                }
                this.setCache(arrayList);
            }
            return this.getCachedObjects();
        }

        public CasFunction getObject(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable CasKeyspace casKeyspace, @NotNull String string) throws DBException {
            return (CasFunction)DBUtils.findObject(this.getAllObjects(dBRProgressMonitor, casKeyspace), (String)string);
        }
    }

    class MaterializedViewCache
    extends AbstractObjectCache<CasKeyspace, CasMView> {
        MaterializedViewCache() {
        }

        @NotNull
        public Collection<CasMView> getAllObjects(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasMView> arrayList = new ArrayList<CasMView>();
                for (MaterializedViewMetadata materializedViewMetadata : CasKeyspace.this.metadata.getMaterializedViews()) {
                    arrayList.add(new CasMView(casKeyspace, materializedViewMetadata));
                    if (dBRProgressMonitor.isCanceled()) break;
                }
                this.setCache(arrayList);
            }
            return this.getCachedObjects();
        }

        public CasMView getObject(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable CasKeyspace casKeyspace, @NotNull String string) throws DBException {
            return (CasMView)DBUtils.findObject(this.getAllObjects(dBRProgressMonitor, casKeyspace), (String)string);
        }
    }

    class TableCache
    extends AbstractObjectCache<CasKeyspace, CasTable> {
        TableCache() {
        }

        @NotNull
        public Collection<CasTable> getAllObjects(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasTable> arrayList = new ArrayList<CasTable>();
                for (TableMetadata tableMetadata : CasKeyspace.this.metadata.getTables()) {
                    arrayList.add(new CasTable(casKeyspace, tableMetadata));
                    if (dBRProgressMonitor.isCanceled()) break;
                }
                Collections.sort(arrayList, DBUtils.nameComparator());
                this.setCache(arrayList);
            }
            return this.getCachedObjects();
        }

        public CasTable getObject(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable CasKeyspace casKeyspace, @NotNull String string) throws DBException {
            return (CasTable)DBUtils.findObject(this.getAllObjects(dBRProgressMonitor, casKeyspace), (String)string);
        }
    }

    class UserTypeCache
    extends AbstractObjectCache<CasKeyspace, CasUserType> {
        UserTypeCache() {
        }

        @NotNull
        public Collection<CasUserType> getAllObjects(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable CasKeyspace casKeyspace) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasUserType> arrayList = new ArrayList<CasUserType>();
                for (UserType userType : CasKeyspace.this.metadata.getUserTypes()) {
                    arrayList.add(new CasUserType(casKeyspace, userType));
                    if (dBRProgressMonitor.isCanceled()) break;
                }
                this.setCache(arrayList);
            }
            return this.getCachedObjects();
        }

        public CasUserType getObject(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable CasKeyspace casKeyspace, @NotNull String string) throws DBException {
            return (CasUserType)DBUtils.findObject(this.getAllObjects(dBRProgressMonitor, casKeyspace), (String)string);
        }
    }
}

