/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.exec;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.dbeaver.ee.cassandra.exec.CasBaseStatement;
import com.dbeaver.ee.cassandra.exec.CasSession;
import java.util.concurrent.TimeUnit;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.utils.CommonUtils;

public class CasSimpleStatement
extends CasBaseStatement {
    private Statement builtStatement;

    public CasSimpleStatement(CasSession casSession, String string) {
        super(casSession, string);
        this.builtStatement = new SimpleStatement(string);
        this.builtStatement.setConsistencyLevel(casSession.getExecutionContext().getCurrentConsistencyLevel());
        if (CommonUtils.toBoolean((Object)casSession.getDataSource().getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-enable.query.trace@"))) {
            this.builtStatement.enableTracing();
        }
    }

    @Override
    public Statement getStatementImpl() {
        return this.builtStatement;
    }

    public boolean executeStatement() throws DBCException {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock("Execute statement");
        try {
            Session session = this.session.getImpl();
            long l = this.statementTimeout * 1000;
            if (l > 0L) {
                this.builtStatement.setReadTimeoutMillis((int)l);
            }
            this.resultSetFuture = session.executeAsync(this.builtStatement);
            try {
                this.result = l > 0L ? (ResultSet)this.resultSetFuture.get(l, TimeUnit.SECONDS) : (ResultSet)this.resultSetFuture.get();
            }
            finally {
                this.resultSetFuture = null;
            }
            ColumnDefinitions columnDefinitions = this.result.getColumnDefinitions();
            if (columnDefinitions == null || columnDefinitions.size() == 0) {
                this.result = null;
            }
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable throwable) {
            throw this.handleExecuteError(throwable);
        }
        finally {
            this.endBlock();
            if (this.session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }
}

