/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.data;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.dbeaver.ee.cassandra.data.CasAbstractValue;
import com.dbeaver.ee.cassandra.data.CasContentBytes;
import com.dbeaver.ee.cassandra.data.CasListValue;
import com.dbeaver.ee.cassandra.data.CasMapValue;
import com.dbeaver.ee.cassandra.data.CasSetValue;
import com.dbeaver.ee.cassandra.data.CasUDTValue;
import com.dbeaver.ee.cassandra.exec.CasResultSet;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasTupleType;
import com.dbeaver.ee.cassandra.model.CasTupleTypeAttribute;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class CasTupleValue
extends CasAbstractValue
implements DBDComposite,
DBDValueCloneable {
    private static final Log log = Log.getLog(CasTupleValue.class);
    @Nullable
    private TupleValue rawValue;
    @Nullable
    private CasTupleType tupleType;

    public CasTupleValue(@NotNull CasDataSource casDataSource, @NotNull String string, @Nullable TupleValue tupleValue) throws DBCException {
        super(casDataSource, string);
        this.rawValue = tupleValue;
        this.tupleType = tupleValue == null ? null : casDataSource.getCachedTupleType(tupleValue.getType());
    }

    public CasTupleValue(CasTupleValue casTupleValue) {
        super(casTupleValue);
        this.rawValue = casTupleValue.rawValue;
        this.tupleType = casTupleValue.tupleType;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor dBRProgressMonitor) {
        return new CasTupleValue(this);
    }

    public TupleValue getRawValue() {
        return this.rawValue;
    }

    public boolean isNull() {
        return this.rawValue == null;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
        this.rawValue = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "[NULL]";
        }
        return this.rawValue.toString();
    }

    public CasTupleType getDataType() {
        return this.tupleType;
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        if (this.tupleType == null) {
            return new DBSAttributeBase[0];
        }
        try {
            Collection collection = this.tupleType.getAttributes((DBRProgressMonitor)new VoidProgressMonitor());
            if (collection == null) {
                return new DBSAttributeBase[0];
            }
            DBSAttributeBase[] dBSAttributeBaseArray = new DBSAttributeBase[collection.size()];
            collection.toArray(dBSAttributeBaseArray);
            return dBSAttributeBaseArray;
        }
        catch (DBException dBException) {
            log.error((Object)dBException);
            return new DBSAttributeBase[0];
        }
    }

    @Nullable
    public Object getAttributeValue(@NotNull DBSAttributeBase dBSAttributeBase) throws DBCException {
        if (this.rawValue == null) {
            return null;
        }
        int n = dBSAttributeBase.getOrdinalPosition() - 1;
        DataType dataType = ((CasTupleTypeAttribute)dBSAttributeBase).getCasDataType();
        switch (dataType.getName()) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return this.rawValue.getString(n);
            }
            case TINYINT: {
                return this.rawValue.getByte(n);
            }
            case SMALLINT: {
                return this.rawValue.getShort(n);
            }
            case INT: {
                return this.rawValue.getInt(n);
            }
            case BIGINT: {
                return this.rawValue.getLong(n);
            }
            case COUNTER: {
                return this.rawValue.getLong(n);
            }
            case VARINT: {
                return this.rawValue.getVarint(n);
            }
            case DECIMAL: {
                return this.rawValue.getDecimal(n);
            }
            case FLOAT: {
                return Float.valueOf(this.rawValue.getFloat(n));
            }
            case DOUBLE: {
                return this.rawValue.getDouble(n);
            }
            case BOOLEAN: {
                return this.rawValue.getBool(n);
            }
            case DATE: {
                return this.rawValue.getDate(n);
            }
            case TIME: {
                return this.rawValue.getTime(n);
            }
            case TIMESTAMP: {
                return this.rawValue.getTimestamp(n);
            }
            case UUID: 
            case TIMEUUID: {
                return this.rawValue.getUUID(n);
            }
            case INET: {
                return this.rawValue.getInet(n);
            }
            case MAP: {
                return new CasMapValue(this.dataSource, this.keyspace, this.rawValue.getMap(n, CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(0)), CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(1))), dataType);
            }
            case LIST: {
                return new CasListValue((DBRProgressMonitor)new VoidProgressMonitor(), this.dataSource, this.keyspace, this.rawValue.getList(n, CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(0))), dataType);
            }
            case SET: {
                return new CasSetValue(this.dataSource, this.keyspace, this.rawValue.getSet(n, CasResultSet.getClassFromType((DataType)dataType.getTypeArguments().get(0))), dataType);
            }
            case TUPLE: {
                return new CasTupleValue(this.dataSource, this.keyspace, this.rawValue.getTupleValue(n));
            }
            case UDT: {
                return new CasUDTValue(this.dataSource, this.keyspace, this.rawValue.getUDTValue(n));
            }
        }
        return new CasContentBytes(this.dataSource, this.rawValue.getBytes(n));
    }

    public void setAttributeValue(@NotNull DBSAttributeBase dBSAttributeBase, @Nullable Object object) {
        if (this.rawValue == null) {
            this.rawValue = this.tupleType.getMetadata().newValue();
        }
        int n = dBSAttributeBase.getOrdinalPosition() - 1;
        if (object == null) {
            this.rawValue.setToNull(n);
            return;
        }
        DataType dataType = ((CasTupleTypeAttribute)dBSAttributeBase).getCasDataType();
        switch (dataType.getName()) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                this.rawValue.setString(n, (String)object);
                break;
            }
            case TINYINT: {
                this.rawValue.setByte(n, ((Byte)object).byteValue());
                break;
            }
            case SMALLINT: {
                this.rawValue.setShort(n, ((Short)object).shortValue());
                break;
            }
            case INT: {
                this.rawValue.setInt(n, ((Integer)object).intValue());
                break;
            }
            case BIGINT: {
                this.rawValue.setLong(n, ((Long)object).longValue());
                break;
            }
            case COUNTER: {
                this.rawValue.setLong(n, ((Long)object).longValue());
                break;
            }
            case VARINT: {
                this.rawValue.setVarint(n, (BigInteger)object);
                break;
            }
            case DECIMAL: {
                this.rawValue.setDecimal(n, (BigDecimal)object);
                break;
            }
            case FLOAT: {
                this.rawValue.setFloat(n, ((Float)object).floatValue());
                break;
            }
            case DOUBLE: {
                this.rawValue.setDouble(n, ((Double)object).doubleValue());
                break;
            }
            case BOOLEAN: {
                this.rawValue.setBool(n, ((Boolean)object).booleanValue());
                break;
            }
            case DATE: {
                this.rawValue.setDate(n, (LocalDate)object);
                break;
            }
            case TIME: {
                this.rawValue.setTime(n, ((Long)object).longValue());
                break;
            }
            case TIMESTAMP: {
                this.rawValue.setTimestamp(n, (Date)object);
                break;
            }
            case UUID: 
            case TIMEUUID: {
                this.rawValue.setUUID(n, (UUID)object);
                break;
            }
            case INET: {
                this.rawValue.setInet(n, (InetAddress)object);
                break;
            }
            case MAP: {
                this.rawValue.setMap(n, (Map)object);
                break;
            }
            case LIST: {
                this.rawValue.setList(n, (List)object);
                break;
            }
            case SET: {
                this.rawValue.setSet(n, (Set)object);
            }
            case TUPLE: {
                this.rawValue.setTupleValue(n, (TupleValue)object);
                break;
            }
            case UDT: {
                this.rawValue.setUDTValue(n, (UDTValue)object);
                break;
            }
            default: {
                this.rawValue.setBytes(n, (ByteBuffer)object);
            }
        }
    }
}

