/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.ColumnMetadata;
import com.dbeaver.ee.cassandra.model.CasTable;
import com.dbeaver.ee.cassandra.model.CasTableColumn;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;

public class CasTableKey
implements DBSTableConstraint,
DBSEntityReferrer {
    public static final DBSEntityConstraintType PARTITION_KEY = new DBSEntityConstraintType("prtkey", "PARTITION KEY", "Partition Key", false, false, false);
    private static final Log log = Log.getLog(CasTableKey.class);
    private final CasTable table;
    private final List<KeyColumn> columns;
    private final DBSEntityConstraintType type;

    public CasTableKey(DBRProgressMonitor dBRProgressMonitor, CasTable casTable, List<ColumnMetadata> list, DBSEntityConstraintType dBSEntityConstraintType) throws DBException {
        this.table = casTable;
        this.columns = new ArrayList<KeyColumn>();
        for (ColumnMetadata columnMetadata : list) {
            CasTableColumn casTableColumn = casTable.getAttribute(dBRProgressMonitor, columnMetadata.getName());
            if (casTableColumn == null) {
                log.error((Object)("Column '" + columnMetadata.getName() + "' not found"));
                continue;
            }
            this.columns.add(new KeyColumn(casTableColumn));
        }
        this.type = dBSEntityConstraintType;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.type.getName();
    }

    @Property(viewable=true, editable=true, order=2)
    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return this.type;
    }

    public CasTable getParentObject() {
        return this.table;
    }

    public String getDescription() {
        return null;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.table.getDataSource();
    }

    public boolean isPersisted() {
        return true;
    }

    public List<KeyColumn> getAttributeReferences(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.columns;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext dBPEvaluationContext) {
        return this.getName();
    }

    public class KeyColumn
    implements DBSObject,
    DBSEntityAttributeRef {
        private final CasTableColumn column;

        public KeyColumn(CasTableColumn casTableColumn) {
            this.column = casTableColumn;
        }

        @NotNull
        public DBSEntityAttribute getAttribute() {
            return this.column;
        }

        public DBSObject getParentObject() {
            return CasTableKey.this;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return CasTableKey.this.getDataSource();
        }

        @Property(viewable=true, editable=true, order=1)
        @NotNull
        public String getName() {
            return this.column.getName();
        }

        public boolean isPersisted() {
            return true;
        }

        public String getDescription() {
            return null;
        }
    }
}

