/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.NettySSLOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.TupleType;
import com.dbeaver.ee.cassandra.CasUtils;
import com.dbeaver.ee.cassandra.exec.CasSession;
import com.dbeaver.ee.cassandra.model.CasCQLDialect;
import com.dbeaver.ee.cassandra.model.CasDataSourceInfo;
import com.dbeaver.ee.cassandra.model.CasDataType;
import com.dbeaver.ee.cassandra.model.CasExecutionContext;
import com.dbeaver.ee.cassandra.model.CasHost;
import com.dbeaver.ee.cassandra.model.CasKeyspace;
import com.dbeaver.ee.cassandra.model.CasRole;
import com.dbeaver.ee.cassandra.model.CasStructureAssistant;
import com.dbeaver.ee.cassandra.model.CasTupleType;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;

public class CasDataSource
implements DBPDataSource,
SQLDataSource,
DBSInstance,
DBSObjectSelector,
DBSObjectContainer,
DBPRefreshableObject,
DBPTermProvider,
DBPDataTypeProvider,
DBPErrorAssistant,
IAdaptable {
    private static final Log log = Log.getLog(CasDataSource.class);
    private Pattern ERROR_POSITION_PATTERN = Pattern.compile("line\\s+([0-9]+):([0-9]+)");
    @NotNull
    private DBPDataSourceContainer container;
    @NotNull
    private CasExecutionContext executionContext;
    List<CasExecutionContext> allContexts = new ArrayList<CasExecutionContext>();
    @NotNull
    private Cluster cluster;
    private String selectedKeyspace;
    private List<CasKeyspace> keyspaces = new ArrayList<CasKeyspace>();
    private List<CasHost> hosts;
    private List<CasRole> roles;
    private CasDataSourceInfo info;
    @NotNull
    private final Map<String, CasDataType> typeMap = new LinkedHashMap<String, CasDataType>();
    private final Map<TupleType, CasTupleType> tupleTypeCache = new LinkedHashMap<TupleType, CasTupleType>();

    public CasDataSource(DBRProgressMonitor dBRProgressMonitor, @NotNull DBPDataSourceContainer dBPDataSourceContainer) throws DBException {
        this.container = dBPDataSourceContainer;
        DataType.Name[] nameArray = DataType.Name.values();
        int n = nameArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType.Name name = nameArray[n2];
            this.typeMap.put(name.toString(), new CasDataType(this, name));
            ++n2;
        }
        this.initializeCluster(dBRProgressMonitor);
    }

    private void initializeCluster(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        boolean bl;
        String string;
        String string2;
        String string3;
        int n;
        int n2;
        Object object;
        Object object2;
        String string4;
        DBPConnectionConfiguration dBPConnectionConfiguration = this.getContainer().getActualConnectionConfiguration();
        String string5 = dBPConnectionConfiguration.getHostName();
        String string6 = dBPConnectionConfiguration.getHostPort();
        Cluster.Builder builder = Cluster.builder();
        if (!CommonUtils.isEmpty((String)string5)) {
            builder.addContactPoint(string5.trim());
            string4 = dBPConnectionConfiguration.getProviderProperty("@dbeaver-connection.points@");
            if (!CommonUtils.isEmpty((String)string4)) {
                object = object2 = string4.split(",");
                n2 = ((String[])object2).length;
                n = 0;
                while (n < n2) {
                    string3 = object[n];
                    builder.addContactPoint(string3.trim());
                    ++n;
                }
            }
        }
        if (!CommonUtils.isEmpty((String)string6)) {
            builder.withPort(Integer.parseInt(string6));
        }
        if (!CommonUtils.isEmpty((String)dBPConnectionConfiguration.getUserName())) {
            builder.withCredentials(dBPConnectionConfiguration.getUserName(), dBPConnectionConfiguration.getUserPassword());
        }
        if (CommonUtils.toBoolean((Object)dBPConnectionConfiguration.getProviderProperty("@dbeaver-ssl@"))) {
            this.configureSSL(builder);
        }
        if (dBPConnectionConfiguration.getKeepAliveInterval() > 0) {
            builder.withPoolingOptions(new PoolingOptions().setHeartbeatIntervalSeconds(dBPConnectionConfiguration.getKeepAliveInterval()));
        }
        string4 = new SocketOptions();
        object2 = dBPConnectionConfiguration.getProviderProperty("@dbeaver-cas.timeout.connect@");
        if (!CommonUtils.isEmpty((String)object2)) {
            string4.setConnectTimeoutMillis(CommonUtils.toInt((Object)object2));
        }
        if (!CommonUtils.isEmpty((String)(string3 = dBPConnectionConfiguration.getProviderProperty("@dbeaver-cas.timeout.read@")))) {
            string4.setReadTimeoutMillis(CommonUtils.toInt((Object)string3));
        }
        if ((n = (int)(CommonUtils.getBoolean((String)dBPConnectionConfiguration.getProviderProperty("@dbeaver-cas.net.keepAlive@"), (boolean)false) ? 1 : 0)) != 0) {
            string4.setKeepAlive(true);
        }
        if ((n2 = (int)(CommonUtils.getBoolean((String)dBPConnectionConfiguration.getProviderProperty("@dbeaver-cas.net.reuseAddr@"), (boolean)false) ? 1 : 0)) != 0) {
            string4.setReuseAddress(true);
        }
        if (!CommonUtils.isEmpty((String)(object = dBPConnectionConfiguration.getProviderProperty("@dbeaver-cas.net.receiveBufferSize@")))) {
            string4.setReceiveBufferSize(CommonUtils.toInt((Object)object));
        }
        if (!CommonUtils.isEmpty((String)(string2 = dBPConnectionConfiguration.getProviderProperty("@dbeaver-cas.net.sendBufferSize@")))) {
            string4.setSendBufferSize(CommonUtils.toInt((Object)string2));
        }
        if (!CommonUtils.isEmpty((String)(string = dBPConnectionConfiguration.getProviderProperty("@dbeaver-cas.net.soLinger@")))) {
            string4.setSoLinger(CommonUtils.toInt((Object)string));
        }
        if (bl = CommonUtils.getBoolean((String)dBPConnectionConfiguration.getProviderProperty("@dbeaver-cas.net.tcpNoDelay@"), (boolean)false)) {
            string4.setTcpNoDelay(true);
        }
        builder.withSocketOptions((SocketOptions)string4);
        this.cluster = builder.build();
        this.selectedKeyspace = dBPConnectionConfiguration.getDatabaseName();
        this.executionContext = new CasExecutionContext(this, "Main CQL Connection");
        this.executionContext.connect(dBRProgressMonitor);
    }

    private void configureSSL(Cluster.Builder builder) throws DBException {
        DBWHandlerConfiguration dBWHandlerConfiguration = this.getContainer().getActualConnectionConfiguration().getDeclaredHandler("cassandra_ssl");
        if (dBWHandlerConfiguration != null && dBWHandlerConfiguration.isEnabled()) {
            String string = (String)dBWHandlerConfiguration.getProperties().get("ssl.trustStore");
            String string2 = (String)dBWHandlerConfiguration.getProperties().get("ssl.trustStorePassword");
            String string3 = (String)dBWHandlerConfiguration.getProperties().get("ssl.client.cert");
            String string4 = (String)dBWHandlerConfiguration.getProperties().get("ssl.client.key");
            try {
                KeyStore keyStore;
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.JDK);
                if (!CommonUtils.isEmpty((String)string)) {
                    keyStore = KeyStore.getInstance("JKS");
                    Object object = null;
                    Object var10_12 = null;
                    try (FileInputStream fileInputStream = new FileInputStream(string);){
                        keyStore.load(fileInputStream, CommonUtils.isEmpty((String)string2) ? null : string2.toCharArray());
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                    object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    ((TrustManagerFactory)object).init(keyStore);
                    sslContextBuilder.trustManager((TrustManagerFactory)object);
                } else if (!CommonUtils.isEmpty((String)string3) && !CommonUtils.isEmpty((String)string4)) {
                    sslContextBuilder.keyManager(new File(string3), new File(string4));
                } else {
                    builder.withSSL();
                    return;
                }
                keyStore = new NettySSLOptions(sslContextBuilder.build());
                builder.withSSL((SSLOptions)keyStore);
            }
            catch (Throwable throwable) {
                throw new DBException("Error configuring SSL client using trust store", throwable);
            }
        }
        builder.withSSL();
    }

    @NotNull
    public Cluster getCluster() {
        return this.cluster;
    }

    @Association
    public Collection<CasKeyspace> getKeyspaces() {
        return this.keyspaces;
    }

    public CasKeyspace getKeyspace(String string) {
        return (CasKeyspace)DBUtils.findObject(this.keyspaces, (String)string);
    }

    @Association
    public Collection<CasHost> getHosts(@NotNull DBRProgressMonitor dBRProgressMonitor) {
        if (this.hosts == null) {
            dBRProgressMonitor.beginTask("Load cluster hosts", 1);
            try {
                this.hosts = new ArrayList<CasHost>();
                Set set = this.cluster.getMetadata().getAllHosts();
                for (Host host : set) {
                    this.hosts.add(new CasHost(this, host));
                }
                dBRProgressMonitor.worked(1);
            }
            finally {
                dBRProgressMonitor.done();
            }
        }
        return this.hosts;
    }

    @Association
    public Collection<CasRole> getRoles(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        if (this.roles == null) {
            dBRProgressMonitor.beginTask("Load cluster roles", 1);
            try {
                block34: {
                    this.roles = new ArrayList<CasRole>();
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (CasSession casSession = (CasSession)DBUtils.openMetaSession((DBRProgressMonitor)dBRProgressMonitor, (DBPDataSource)this, (String)"Load roles");){
                            Throwable throwable2 = null;
                            Object var6_10 = null;
                            try (DBCStatement dBCStatement = casSession.prepareStatement(DBCStatementType.QUERY, "LIST ROLES", true, false, false);){
                                if (!dBCStatement.executeStatement()) break block34;
                                Throwable throwable3 = null;
                                Object var9_15 = null;
                                try (DBCResultSet dBCResultSet = dBCStatement.openResultSet();){
                                    while (dBCResultSet.nextRow()) {
                                        String string = CommonUtils.toString((Object)dBCResultSet.getAttributeValue("role"));
                                        boolean bl = CommonUtils.toBoolean((Object)dBCResultSet.getAttributeValue("super"));
                                        boolean bl2 = CommonUtils.toBoolean((Object)dBCResultSet.getAttributeValue("login"));
                                        Map map = (Map)dBCResultSet.getAttributeValue("options");
                                        this.roles.add(new CasRole(this, string, bl, bl2, map));
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable4;
                                    } else if (throwable3 != throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    throw throwable3;
                                }
                            }
                            catch (Throwable throwable5) {
                                if (throwable2 == null) {
                                    throwable2 = throwable5;
                                } else if (throwable2 != throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable == null) {
                                throwable = throwable6;
                            } else if (throwable != throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            throw throwable;
                        }
                    }
                    catch (DBCException dBCException) {
                        throw new DBException("Error reading roles", (Throwable)dBCException);
                    }
                }
                dBRProgressMonitor.worked(1);
            }
            finally {
                dBRProgressMonitor.done();
            }
        }
        return this.roles;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.container;
    }

    @NotNull
    public CasDataSource getDataSource() {
        return this;
    }

    @NotNull
    public DBPDataSourceContainer getContainer() {
        return this.container;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String string) {
        return null;
    }

    @NotNull
    public CasExecutionContext getDefaultContext(boolean bl) {
        return this.executionContext;
    }

    @NotNull
    public CasExecutionContext[] getAllContexts() {
        return this.allContexts.toArray(new CasExecutionContext[this.allContexts.size()]);
    }

    @NotNull
    public DBCExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull String string) throws DBException {
        CasExecutionContext casExecutionContext = new CasExecutionContext(this, string);
        casExecutionContext.connect(dBRProgressMonitor);
        return casExecutionContext;
    }

    public void initialize(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        Metadata metadata = this.cluster.getMetadata();
        List list = metadata.getKeyspaces();
        if (list != null) {
            for (KeyspaceMetadata keyspaceMetadata : list) {
                CasKeyspace casKeyspace = new CasKeyspace(this, keyspaceMetadata);
                this.keyspaces.add(casKeyspace);
            }
            this.keyspaces.sort(DBUtils.nameComparator());
        }
        this.info = new CasDataSourceInfo(metadata);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        this.keyspaces.clear();
        this.shutdown(dBRProgressMonitor);
        this.initializeCluster(dBRProgressMonitor);
        this.initialize(dBRProgressMonitor);
        return this;
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    public String getSelectedKeyspaceName() {
        return this.selectedKeyspace;
    }

    public CasKeyspace getDefaultObject() {
        return this.getKeyspace(this.selectedKeyspace);
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull DBSObject dBSObject) throws DBException {
        if (!(dBSObject instanceof CasKeyspace)) {
            throw new DBException("Bad active object: " + dBSObject);
        }
        CasKeyspace casKeyspace = (CasKeyspace)dBSObject;
        CasKeyspace casKeyspace2 = this.getDefaultObject();
        this.setActiveEntityName(casKeyspace);
        if (casKeyspace2 != null) {
            DBUtils.fireObjectSelect((DBSObject)casKeyspace2, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)casKeyspace, (boolean)true);
    }

    public boolean refreshDefaultObject(@NotNull DBCSession dBCSession) throws DBException {
        return false;
    }

    void setActiveEntityName(CasKeyspace casKeyspace) throws DBException {
        this.selectedKeyspace = casKeyspace.getName();
        for (CasExecutionContext casExecutionContext : this.allContexts) {
            casExecutionContext.reconnect();
        }
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == DBSStructureAssistant.class) {
            return clazz.cast(new CasStructureAssistant(this));
        }
        return null;
    }

    public String getObjectTypeTerm(String string, String string2, boolean bl) {
        String string3 = null;
        if ("cluster".equals(string2)) {
            string3 = "Cluster";
        } else if ("keypace".equals(string2)) {
            string3 = "Keyspace";
        }
        if (string3 != null && bl) {
            string3 = String.valueOf(string3) + "s";
        }
        return string3;
    }

    public DBSInstance getDefaultInstance() {
        return this;
    }

    public Collection<? extends DBSInstance> getAvailableInstances() {
        return Collections.singletonList(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(DBRProgressMonitor dBRProgressMonitor) {
        CasDataSource casDataSource = this;
        synchronized (casDataSource) {
            this.executionContext.close();
            this.cluster.close();
        }
    }

    @NotNull
    public String getName() {
        return this.container.getName();
    }

    public boolean isPersisted() {
        return true;
    }

    public SQLDialect getSQLDialect() {
        return CasCQLDialect.INSTANCE;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.getKeyspaces();
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull String string) throws DBException {
        return this.getKeyspace(string);
    }

    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return CasKeyspace.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor dBRProgressMonitor, int n) throws DBException {
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String string, int n) {
        DataType.Name name = DataType.Name.valueOf((String)string);
        return CasUtils.getDataKind(name);
    }

    public CasDataType resolveDataType(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull String string) throws DBException {
        return this.typeMap.get(string);
    }

    public Collection<? extends DBSDataType> getLocalDataTypes() {
        return new ArrayList<CasDataType>(this.typeMap.values());
    }

    public CasDataType getLocalDataType(String string) {
        return this.typeMap.get(string);
    }

    public DBSDataType getLocalDataType(int n) {
        for (CasDataType casDataType : this.typeMap.values()) {
            if (casDataType.getTypeID() != n) continue;
            return casDataType;
        }
        return null;
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dBPDataKind) {
        switch (dBPDataKind) {
            case BOOLEAN: {
                return DataType.Name.BOOLEAN.toString();
            }
            case NUMERIC: {
                return DataType.Name.INT.toString();
            }
            case DATETIME: {
                return DataType.Name.TIMESTAMP.toString();
            }
            case BINARY: {
                return DataType.Name.BLOB.toString();
            }
            case CONTENT: {
                return DataType.Name.BLOB.toString();
            }
            case STRUCT: {
                return DataType.Name.MAP.toString();
            }
            case ARRAY: {
                return DataType.Name.LIST.toString();
            }
            case OBJECT: {
                return DataType.Name.UDT.toString();
            }
        }
        return DataType.Name.ASCII.toString();
    }

    public synchronized CasTupleType getCachedTupleType(TupleType tupleType) {
        CasTupleType casTupleType = this.tupleTypeCache.get(tupleType);
        if (casTupleType == null) {
            casTupleType = new CasTupleType(this, tupleType);
            this.tupleTypeCache.put(tupleType, casTupleType);
        }
        return casTupleType;
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(Throwable throwable) {
        return DBPErrorAssistant.ErrorType.NORMAL;
    }

    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(DBRProgressMonitor dBRProgressMonitor, DBCExecutionContext dBCExecutionContext, String string, Throwable throwable) {
        Matcher matcher;
        String string2 = throwable.getMessage();
        if (!CommonUtils.isEmpty((String)string2) && (matcher = this.ERROR_POSITION_PATTERN.matcher(string2)).find()) {
            DBPErrorAssistant.ErrorPosition errorPosition = new DBPErrorAssistant.ErrorPosition();
            errorPosition.line = Integer.parseInt(matcher.group(1)) - 1;
            errorPosition.position = Integer.parseInt(matcher.group(2)) - 1;
            return new DBPErrorAssistant.ErrorPosition[]{errorPosition};
        }
        return null;
    }
}

