/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.exec;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.dbeaver.ee.cassandra.exec.CasBaseStatement;
import com.dbeaver.ee.cassandra.exec.CasSession;
import java.util.concurrent.TimeUnit;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.utils.CommonUtils;

public class CasPreparedStatement
extends CasBaseStatement {
    private final PreparedStatement statement;
    private final BoundStatement boundStatement;

    public CasPreparedStatement(CasSession casSession, PreparedStatement preparedStatement) {
        super(casSession, preparedStatement.getQueryString());
        this.statement = preparedStatement;
        this.boundStatement = preparedStatement.bind();
        this.boundStatement.setConsistencyLevel(casSession.getExecutionContext().getCurrentConsistencyLevel());
        if (CommonUtils.toBoolean((Object)casSession.getDataSource().getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-enable.query.trace@"))) {
            this.boundStatement.enableTracing();
        }
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public BoundStatement getBoundStatement() {
        return this.boundStatement;
    }

    public boolean executeStatement() throws DBCException {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock("Execute prepared statement");
        try {
            Session session = this.session.getImpl();
            long l = this.statementTimeout * 1000;
            if (l > 0L) {
                this.boundStatement.setReadTimeoutMillis((int)l);
            }
            this.resultSetFuture = session.executeAsync((Statement)this.boundStatement);
            try {
                this.result = l > 0L ? (ResultSet)this.resultSetFuture.get(l, TimeUnit.SECONDS) : (ResultSet)this.resultSetFuture.get();
            }
            finally {
                this.resultSetFuture = null;
            }
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable throwable) {
            throw this.handleExecuteError(throwable);
        }
        finally {
            this.endBlock();
            if (this.session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    @Override
    public Statement getStatementImpl() {
        return this.boundStatement;
    }
}

