/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.dbeaver.ee.cassandra.exec.CasSession;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasKeyspace;
import com.dbeaver.ee.cassandra.model.CasTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class CasStructureAssistant
implements DBSStructureAssistant {
    private final CasDataSource dataSource;

    public CasStructureAssistant(CasDataSource casDataSource) {
        this.dataSource = casDataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(DBRProgressMonitor dBRProgressMonitor, @Nullable DBSObject dBSObject, DBSObjectType[] dBSObjectTypeArray, String string, boolean bl, boolean bl2, int n) throws DBException {
        ArrayList<DBSObjectReference> arrayList = new ArrayList<DBSObjectReference>();
        Throwable throwable = null;
        Object var10_11 = null;
        try (CasSession casSession = (CasSession)DBUtils.openMetaSession((DBRProgressMonitor)dBRProgressMonitor, (DBSObject)(dBSObject != null ? dBSObject : this.dataSource), (String)"Find Cassandra objects");){
            CasKeyspace casKeyspace = dBSObject instanceof CasKeyspace ? (CasKeyspace)dBSObject : null;
            this.findCollections(casSession, casKeyspace, string, bl, arrayList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return arrayList;
    }

    private void findCollections(CasSession casSession, CasKeyspace casKeyspace, String string, boolean bl, List<DBSObjectReference> list) throws DBException {
        String string2 = string.contains("%") ? string.replace("%", ".*") : Pattern.quote(string);
        Pattern pattern = Pattern.compile(string2, (bl ? 0 : 2) | 8);
        Collection<CasKeyspace> collection = casKeyspace != null ? Collections.singleton(casKeyspace) : this.dataSource.getKeyspaces();
        DBRProgressMonitor dBRProgressMonitor = casSession.getProgressMonitor();
        for (CasKeyspace casKeyspace2 : collection) {
            for (CasTable casTable : casKeyspace2.getTables(dBRProgressMonitor)) {
                if (!pattern.matcher(casTable.getName()).matches()) continue;
                list.add((DBSObjectReference)new CasTableReference(casTable));
            }
        }
    }

    private static class CasTableReference
    extends AbstractObjectReference {
        private final CasTable table;

        private CasTableReference(CasTable casTable) {
            super(casTable.getName(), (DBSObject)casTable.getKeyspace(), null, CasTable.class, RelationalObjectType.TYPE_TABLE);
            this.table = casTable;
        }

        public DBSObject resolveObject(DBRProgressMonitor dBRProgressMonitor) throws DBException {
            return this.table;
        }
    }
}

