/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.FunctionMetadata;
import com.dbeaver.ee.cassandra.model.CasKeyspace;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CasFunction
implements DBSObject,
DBPScriptObject {
    private final CasKeyspace keyspace;
    private final FunctionMetadata metadata;

    public CasFunction(CasKeyspace casKeyspace, FunctionMetadata functionMetadata) {
        this.keyspace = casKeyspace;
        this.metadata = functionMetadata;
    }

    @Nullable
    public String getDescription() {
        return this.metadata.getSignature();
    }

    @Nullable
    public CasKeyspace getParentObject() {
        return this.keyspace;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.keyspace.getDataSource();
    }

    @Property(viewable=true)
    @NotNull
    public String getName() {
        return this.metadata.getSimpleName();
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true)
    public String getSignature() {
        return this.metadata.getSignature();
    }

    @Property
    public Map<String, DataType> getArgumentTypes() {
        return this.metadata.getArguments();
    }

    @Property
    public DataType getReturnType() {
        return this.metadata.getReturnType();
    }

    @Property
    public String getLanguage() {
        return this.metadata.getLanguage();
    }

    public String getObjectDefinitionText(DBRProgressMonitor dBRProgressMonitor, Map<String, Object> map) throws DBException {
        return this.metadata.getBody();
    }
}

