/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Session;
import com.dbeaver.ee.cassandra.exec.CasSession;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.utils.CommonUtils;

public class CasExecutionContext
extends AbstractExecutionContext<CasDataSource> {
    private static final Log log = Log.getLog(CasExecutionContext.class);
    private Session session;
    private ConsistencyLevel currentConsistencyLevel = ConsistencyLevel.ONE;

    public CasExecutionContext(CasDataSource casDataSource, String string) {
        super((DBPDataSource)casDataSource, string);
    }

    public Session getSession() {
        return this.session;
    }

    public void connect(DBRProgressMonitor dBRProgressMonitor) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((CasDataSource)this.dataSource).getContainer());
        try {
            try {
                dBRProgressMonitor.subTask("Open cluster session");
                this.reconnect();
                this.initContextBootstrap(dBRProgressMonitor, true);
                ((CasDataSource)this.dataSource).allContexts.add(this);
            }
            catch (Exception exception) {
                throw new DBCException((Throwable)exception, this.dataSource);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((CasDataSource)this.dataSource).getContainer());
        }
    }

    @NotNull
    public CasSession openSession(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull DBCExecutionPurpose dBCExecutionPurpose, @NotNull String string) {
        return new CasSession(dBRProgressMonitor, dBCExecutionPurpose, string, this);
    }

    public void checkContextAlive(DBRProgressMonitor dBRProgressMonitor) throws DBException {
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return true;
    }

    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor dBRProgressMonitor, boolean bl) throws DBException {
        return DBCExecutionContext.InvalidateResult.ALIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CasExecutionContext casExecutionContext = this;
        synchronized (casExecutionContext) {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            super.closeContext();
        }
        ((CasDataSource)this.dataSource).allContexts.add(this);
    }

    public void reconnect() {
        String string;
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        this.session = CommonUtils.isEmpty((String)(string = ((CasDataSource)this.dataSource).getSelectedKeyspaceName())) ? ((CasDataSource)this.dataSource).getCluster().connect() : ((CasDataSource)this.dataSource).getCluster().connect(string);
        String string2 = ((CasDataSource)this.dataSource).getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-default.consistency.level@");
        if (!CommonUtils.isEmpty((String)string2)) {
            try {
                this.currentConsistencyLevel = ConsistencyLevel.valueOf((String)string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.debug((Object)("Bad default consistency level: " + string2));
            }
        }
    }

    public ConsistencyLevel getCurrentConsistencyLevel() {
        return this.currentConsistencyLevel;
    }

    public void setCurrentConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.currentConsistencyLevel = consistencyLevel;
    }
}

