/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.data.handlers;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.dbeaver.ee.cassandra.CasUtils;
import com.dbeaver.ee.cassandra.exec.CasPreparedStatement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.data.DateTimeCustomValueHandler;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasTimestampValueHandler
extends DateTimeCustomValueHandler {
    public CasTimestampValueHandler(DBDDataFormatterProfile dBDDataFormatterProfile) {
        super(dBDDataFormatterProfile);
    }

    @NotNull
    public String getFormatterId(DBSTypedObject dBSTypedObject) {
        if (dBSTypedObject.getTypeID() == CasUtils.getTypeNameID(DataType.Name.DATE)) {
            return "date";
        }
        if (dBSTypedObject.getTypeID() == CasUtils.getTypeNameID(DataType.Name.TIME)) {
            return "time";
        }
        return "timestamp";
    }

    public Object fetchValueObject(@NotNull DBCSession dBCSession, @NotNull DBCResultSet dBCResultSet, @NotNull DBSTypedObject dBSTypedObject, int n) throws DBCException {
        return dBCResultSet.getAttributeValue(n);
    }

    public final void bindValueObject(@NotNull DBCSession dBCSession, @NotNull DBCStatement dBCStatement, @NotNull DBSTypedObject dBSTypedObject, int n, Object object) throws DBCException {
        try {
            Object object2 = this.getValueFromObject(dBCSession, dBSTypedObject, object, false);
            int n2 = dBSTypedObject.getTypeID();
            BoundStatement boundStatement = ((CasPreparedStatement)dBCStatement).getBoundStatement();
            if (object2 == null) {
                boundStatement.setToNull(n);
            } else if (n2 == CasUtils.getTypeNameID(DataType.Name.DATE)) {
                if (object2 instanceof Number) {
                    boundStatement.setDate(n, CasUtils.toLocalDate(new Date(((Number)object2).longValue())));
                } else if (object2 instanceof LocalDate) {
                    boundStatement.setDate(n, (LocalDate)object2);
                } else if (object2 instanceof Date) {
                    boundStatement.setDate(n, CasUtils.toLocalDate((Date)object2));
                }
            } else if (n2 == CasUtils.getTypeNameID(DataType.Name.TIME)) {
                if (object2 instanceof Number) {
                    boundStatement.setTime(n, ((Number)object2).longValue());
                } else if (object2 instanceof Date) {
                    boundStatement.setTime(n, CasUtils.toCasTime((Date)object2));
                }
            } else if (object2 instanceof Number) {
                boundStatement.setTimestamp(n, new Date(((Number)object2).longValue()));
            } else if (object2 instanceof Date) {
                boundStatement.setTimestamp(n, (Date)object2);
            }
        }
        catch (Exception exception) {
            throw new DBCException("Error binding statement parameter", (Throwable)exception);
        }
    }

    public Object getValueFromObject(@NotNull DBCSession dBCSession, @NotNull DBSTypedObject dBSTypedObject, Object object, boolean bl) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Number || object instanceof Date || object instanceof LocalDate) {
            return object;
        }
        if (object instanceof String) {
            Object object2;
            try {
                object2 = this.getFormatter(dBSTypedObject).parseValue((String)object, null);
            }
            catch (ParseException parseException) {
                log.debug((Object)("Unsupported Cassandra date/time value: " + object));
                return object;
            }
            if (object2 == null) {
                return null;
            }
            if (object2 instanceof Date) {
                if (dBSTypedObject.getTypeID() == CasUtils.getTypeNameID(DataType.Name.TIME)) {
                    return CasUtils.toCasTime((Date)object2);
                }
                if (dBSTypedObject.getTypeID() == CasUtils.getTypeNameID(DataType.Name.DATE)) {
                    return CasUtils.toLocalDate((Date)object2);
                }
                return object2;
            }
        }
        throw new DBCException("Unsupported Cassandra date/time value: " + object);
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject dBSTypedObject, Object object, @NotNull DBDDisplayFormat dBDDisplayFormat) {
        if (dBSTypedObject instanceof DBSObject && ((DBSObject)dBSTypedObject).getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.format.datetime.native")) {
            return DBValueFormatting.getDefaultValueDisplayString((Object)object, (DBDDisplayFormat)dBDDisplayFormat);
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, localDate.getYear());
            calendar.set(2, localDate.getMonth() - 1);
            calendar.set(5, localDate.getDay());
            object = calendar.getTime();
        } else if (object instanceof Number) {
            if (dBSTypedObject.getTypeID() == CasUtils.getTypeNameID(DataType.Name.TIME)) {
                long l = ((Number)object).longValue();
                Timestamp timestamp = new Timestamp(l / 1000000L - (long)TimeZone.getDefault().getRawOffset());
                timestamp.setNanos((int)(l % 1000000L));
                object = timestamp;
            } else {
                object = new Date(((Number)object).longValue());
            }
        }
        return super.getValueDisplayString(dBSTypedObject, object, dBDDisplayFormat);
    }
}

