/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.data.handlers;

import com.datastax.driver.core.DataType;
import com.dbeaver.ee.cassandra.data.CasMapValue;
import com.dbeaver.ee.cassandra.data.handlers.CasComplexValueHandler;
import com.dbeaver.ee.cassandra.exec.CasPreparedStatement;
import com.dbeaver.ee.cassandra.exec.CasSession;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasTableColumn;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasMapValueHandler
extends CasComplexValueHandler {
    private static final Log log = Log.getLog(CasMapValueHandler.class);
    public static final CasMapValueHandler INSTANCE = new CasMapValueHandler();

    @NotNull
    public Class<CasMapValue> getValueObjectType(@NotNull DBSTypedObject dBSTypedObject) {
        return CasMapValue.class;
    }

    public CasMapValue getValueFromObject(@NotNull DBCSession dBCSession, @NotNull DBSTypedObject dBSTypedObject, Object object, boolean bl) throws DBCException {
        CasDataSource casDataSource = (CasDataSource)dBCSession.getDataSource();
        if (object == null) {
            DataType.CollectionType collectionType = DataType.map((DataType)DataType.text(), (DataType)DataType.text());
            if (dBSTypedObject instanceof CasTableColumn) {
                collectionType = ((CasTableColumn)dBSTypedObject).getMetadata().getType();
            }
            return new CasMapValue(casDataSource, casDataSource.getSelectedKeyspaceName(), null, (DataType)collectionType);
        }
        if (object instanceof CasMapValue) {
            return bl ? new CasMapValue((CasMapValue)object) : (CasMapValue)object;
        }
        throw new DBCException("Unsupported map type: " + object.getClass().getName());
    }

    @Override
    protected void bindParameter(CasSession casSession, CasPreparedStatement casPreparedStatement, DBSTypedObject dBSTypedObject, int n, Object object) throws DBCException {
        casPreparedStatement.getBoundStatement().setMap(n, ((CasMapValue)object).makeMap());
    }

    public String getValueDisplayString(DBSTypedObject dBSTypedObject, Object object, DBDDisplayFormat dBDDisplayFormat) {
        if (object instanceof CasMapValue) {
            try {
                CasMapValue casMapValue = (CasMapValue)object;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('{');
                int n = 0;
                while (n < casMapValue.getItemCount()) {
                    if (n > 0) {
                        stringBuilder.append(',');
                    }
                    DBDComposite dBDComposite = casMapValue.getItem(n);
                    DBSAttributeBase[] dBSAttributeBaseArray = dBDComposite.getAttributes();
                    stringBuilder.append('\'').append(dBDComposite.getAttributeValue(dBSAttributeBaseArray[0])).append('\'').append(':');
                    DBDValueHandler dBDValueHandler = DBUtils.findValueHandler((DBPDataSource)casMapValue.getDataSource(), (DBSTypedObject)dBSAttributeBaseArray[1]);
                    stringBuilder.append('\'').append(dBDValueHandler.getValueDisplayString((DBSTypedObject)dBSAttributeBaseArray[1], dBDComposite.getAttributeValue(dBSAttributeBaseArray[1]), DBDDisplayFormat.NATIVE)).append('\'');
                    ++n;
                }
                stringBuilder.append('}');
                return stringBuilder.toString();
            }
            catch (DBCException dBCException) {
                log.error((Object)dBCException);
                return dBCException.getMessage();
            }
        }
        return super.getValueDisplayString(dBSTypedObject, object, dBDDisplayFormat);
    }
}

