/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.data;

import com.datastax.driver.core.DataType;
import com.dbeaver.ee.cassandra.CasUtils;
import com.dbeaver.ee.cassandra.data.CasAbstractValue;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.struct.AbstractAttribute;
import org.jkiss.dbeaver.model.impl.struct.AbstractStructDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasMapValue
extends CasAbstractValue
implements DBDCollection,
DBDValueCloneable {
    private final DataType mapType;
    private final EntryType entryType;
    private final EntryAttribute[] attributes;
    private List<EntryComposite> contents;
    private boolean modified;

    public CasMapValue(CasDataSource casDataSource, String string, Map<?, ?> map, DataType dataType) throws DBCException {
        super(casDataSource, string);
        if (map != null) {
            this.contents = new ArrayList<EntryComposite>();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.contents.add(new EntryComposite(entry));
            }
        }
        this.mapType = dataType;
        this.entryType = new EntryType();
        this.attributes = new EntryAttribute[2];
        this.attributes[0] = new EntryAttribute("key", (DataType)dataType.getTypeArguments().get(0), 0);
        this.attributes[1] = new EntryAttribute("value", (DataType)dataType.getTypeArguments().get(1), 1);
    }

    public CasMapValue(CasMapValue casMapValue) {
        super(casMapValue);
        this.contents = new ArrayList<EntryComposite>(casMapValue.contents);
        this.mapType = casMapValue.mapType;
        this.entryType = casMapValue.entryType;
        this.attributes = casMapValue.attributes;
    }

    public CasDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBSDataType getComponentType() {
        return this.entryType;
    }

    @NotNull
    public DBDValueHandler getComponentValueHandler() {
        return DBUtils.findValueHandler((DBPDataSource)this.dataSource, (DBSTypedObject)this.entryType);
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor dBRProgressMonitor) {
        return new CasMapValue(this);
    }

    public Object getRawValue() {
        return this.contents;
    }

    public boolean isNull() {
        return this.contents == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.contents = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        CasDataType casDataType = this.dataSource.getLocalDataType(this.attributes[0].type.getName().toString());
        if (casDataType == null) {
            return String.valueOf(this.attributes[0].type.getName().toString()) + " " + " not found";
        }
        DBDValueHandler dBDValueHandler = DBUtils.findValueHandler((DBPDataSource)this.dataSource, (DBSTypedObject)casDataType);
        if (dBDValueHandler == null) {
            return String.valueOf(casDataType.getName()) + " " + " handler not found";
        }
        CasDataType casDataType2 = this.dataSource.getLocalDataType(this.attributes[1].type.getName().toString());
        if (casDataType2 == null) {
            return String.valueOf(this.attributes[1].type.getName().toString()) + " " + " not found";
        }
        DBDValueHandler dBDValueHandler2 = DBUtils.findValueHandler((DBPDataSource)this.dataSource, (DBSTypedObject)casDataType2);
        if (dBDValueHandler2 == null) {
            return String.valueOf(casDataType2.getName()) + " " + " handler not found";
        }
        StringBuilder stringBuilder = new StringBuilder(this.contents.size() * 32);
        stringBuilder.append("{");
        int n = 0;
        while (n < this.contents.size()) {
            EntryComposite entryComposite = this.contents.get(n);
            if (n > 0) {
                stringBuilder.append(',');
            }
            SQLUtils.appendValue((StringBuilder)stringBuilder, (DBSTypedObject)casDataType, (Object)dBDValueHandler.getValueDisplayString((DBSTypedObject)casDataType, entryComposite.key, DBDDisplayFormat.NATIVE));
            stringBuilder.append(" : ");
            SQLUtils.appendValue((StringBuilder)stringBuilder, (DBSTypedObject)casDataType2, (Object)dBDValueHandler.getValueDisplayString((DBSTypedObject)casDataType2, entryComposite.value, DBDDisplayFormat.NATIVE));
            ++n;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int getItemCount() {
        return this.contents == null ? 0 : this.contents.size();
    }

    public DBDComposite getItem(int n) {
        return this.contents.get(n);
    }

    public void setItem(int n, Object object) {
        this.contents.set(n, (EntryComposite)object);
        this.modified = true;
    }

    public void setContents(Object[] objectArray) {
        this.contents.clear();
        int n = 0;
        while (n < objectArray.length) {
            this.setItem(n, objectArray[n]);
            ++n;
        }
        this.modified = true;
    }

    public DataType getMapType() {
        return this.mapType;
    }

    public Map<Object, Object> makeMap() {
        if (this.contents == null) {
            return null;
        }
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>(this.contents.size());
        for (EntryComposite entryComposite : this.contents) {
            linkedHashMap.put(entryComposite.key, CasUtils.unwrapValue(this.dataSource, entryComposite.value));
        }
        return linkedHashMap;
    }

    private class EntryAttribute
    extends AbstractAttribute
    implements DBSEntityAttribute {
        private DataType type;

        private EntryAttribute(String string, DataType dataType, int n) {
            super(string, dataType.getName().toString(), CasUtils.getTypeNameID(dataType), n, 0L, null, null, true, false);
            this.type = dataType;
        }

        @Nullable
        public String getDefaultValue() {
            return null;
        }

        @NotNull
        public DBSEntity getParentObject() {
            return CasMapValue.this.entryType;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return CasMapValue.this.dataSource;
        }

        public DBPDataKind getDataKind() {
            return CasUtils.getDataKind(this.type);
        }
    }

    private class EntryComposite
    implements DBDComposite {
        private Object key;
        private Object value;

        private EntryComposite(Map.Entry<?, ?> entry) throws DBCException {
            this.key = entry.getKey();
            this.value = CasUtils.wrapValue(CasMapValue.this.dataSource, CasMapValue.this.keyspace, entry.getValue());
        }

        public DBSDataType getDataType() {
            return CasMapValue.this.entryType;
        }

        @NotNull
        public DBSAttributeBase[] getAttributes() {
            return CasMapValue.this.attributes;
        }

        @Nullable
        public Object getAttributeValue(@NotNull DBSAttributeBase dBSAttributeBase) throws DBCException {
            if (dBSAttributeBase.getOrdinalPosition() == 0) {
                return this.key;
            }
            return this.value;
        }

        public void setAttributeValue(@NotNull DBSAttributeBase dBSAttributeBase, @Nullable Object object) {
            if (dBSAttributeBase.getOrdinalPosition() == 0) {
                throw new IllegalArgumentException("Key is read-only");
            }
            this.value = object;
            CasMapValue.this.modified = true;
        }

        public Object getRawValue() {
            return this.value;
        }

        public boolean isNull() {
            return false;
        }

        public boolean isModified() {
            return CasMapValue.this.modified;
        }

        public void release() {
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class EntryType
    extends AbstractStructDataType<CasDataSource>
    implements DBSEntity {
        public EntryType() {
            super((DBPDataSource)CasMapValue.this.dataSource);
        }

        public String getTypeName() {
            return CasMapValue.this.mapType.getName().toString();
        }

        public int getTypeID() {
            return CasUtils.getTypeNameID(CasMapValue.this.mapType);
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.STRUCT;
        }

        @NotNull
        public DBSEntityType getEntityType() {
            return DBSEntityType.VIRTUAL_ENTITY;
        }

        @Nullable
        public Collection<? extends DBSEntityAttribute> getAttributes(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
            return Arrays.asList(CasMapValue.this.attributes);
        }
    }
}

