/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.model;

import com.dbeaver.ee.influxdb.InfluxConstants;
import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import com.dbeaver.ee.influxdb.model.InfluxMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.struct.DirectObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class InfluxStructureAssistant
implements DBSStructureAssistant {
    private final InfluxDataSource dataSource;

    public InfluxStructureAssistant(InfluxDataSource influxDataSource) {
        this.dataSource = influxDataSource;
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE};
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(DBRProgressMonitor dBRProgressMonitor, @Nullable DBSObject dBSObject, DBSObjectType[] dBSObjectTypeArray, String string, boolean bl, boolean bl2, int n) throws DBException {
        ArrayList<DBSObjectReference> arrayList = new ArrayList<DBSObjectReference>();
        Throwable throwable = null;
        Object var10_11 = null;
        try (InfluxSession influxSession = (InfluxSession)DBUtils.openMetaSession((DBRProgressMonitor)dBRProgressMonitor, (DBSObject)(dBSObject != null ? dBSObject : this.dataSource), (String)"Find Cassandra objects");){
            InfluxDatabase influxDatabase = dBSObject instanceof InfluxDatabase ? (InfluxDatabase)dBSObject : influxSession.getDataSource().getDefaultObject();
            this.findCollections(influxSession, influxDatabase, string, bl, arrayList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return arrayList;
    }

    private void findCollections(InfluxSession influxSession, @NotNull InfluxDatabase influxDatabase, String string, boolean bl, List<DBSObjectReference> list) throws DBException {
        String string2 = string.contains("%") ? string.replace("%", ".*") : Pattern.quote(string);
        Pattern pattern = Pattern.compile(string2, (bl ? 0 : 2) | 8);
        influxSession.getProgressMonitor();
        for (InfluxMeasurement influxMeasurement : influxDatabase.getMeasurements(influxSession.getProgressMonitor())) {
            if (!pattern.matcher(influxMeasurement.getName()).matches()) continue;
            list.add((DBSObjectReference)new DirectObjectReference((DBSObject)influxDatabase, InfluxConstants.TYPE_MEASUREMENT, (DBSObject)influxMeasurement));
        }
    }
}

