/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.model;

import com.dbeaver.ee.influxdb.InfluxUtils;
import com.dbeaver.ee.influxdb.model.InfluxDataSource;
import com.dbeaver.ee.influxdb.model.InfluxMeasurement;
import com.dbeaver.ee.influxdb.model.InfluxRetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.AbstractObjectCache;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.CommonUtils;

public class InfluxDatabase
implements DBSCatalog,
DBPSaveableObject,
DBPSystemObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(InfluxDatabase.class);
    private final InfluxDataSource dataSource;
    private final String dbName;
    private boolean persisted;
    private MeasurementCache measurementCache = new MeasurementCache();
    private RetentionPolicyCache retentionPolicyCache = new RetentionPolicyCache();

    public InfluxDatabase(InfluxDataSource influxDataSource, String string) {
        this.dataSource = influxDataSource;
        this.dbName = string;
        this.persisted = true;
    }

    @NotNull
    public InfluxDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.dbName;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean bl) {
        this.persisted = bl;
    }

    public List<InfluxMeasurement> getChildren(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.getMeasurements(dBRProgressMonitor);
    }

    public InfluxMeasurement getChild(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull String string) throws DBException {
        return (InfluxMeasurement)DBUtils.findObject((List)this.getChildren(dBRProgressMonitor), (String)string);
    }

    public Class<InfluxMeasurement> getChildType(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return InfluxMeasurement.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor dBRProgressMonitor, int n) throws DBException {
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSystem() {
        return this.dbName.equals("_internal");
    }

    @Association
    public List<InfluxMeasurement> getMeasurements(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.measurementCache.getAllObjects(dBRProgressMonitor, this);
    }

    @Association
    public List<InfluxRetentionPolicy> getRetentionPolicies(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.retentionPolicyCache.getAllObjects(dBRProgressMonitor, this);
    }

    public DBSObject refreshObject(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        this.measurementCache.clearCache();
        this.retentionPolicyCache.clearCache();
        return this;
    }

    class MeasurementCache
    extends AbstractObjectCache<InfluxDatabase, InfluxMeasurement> {
        MeasurementCache() {
        }

        @NotNull
        public List<InfluxMeasurement> getAllObjects(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable InfluxDatabase influxDatabase) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<InfluxMeasurement> arrayList = new ArrayList<InfluxMeasurement>();
                InfluxDB influxDB = InfluxDatabase.this.getDataSource().getDefaultContext(true).getInfluxDB();
                QueryResult queryResult = influxDB.query(new Query("SHOW MEASUREMENTS", InfluxDatabase.this.getName()));
                for (QueryResult.Result result : queryResult.getResults()) {
                    for (QueryResult.Series series : CommonUtils.safeList((List)result.getSeries())) {
                        for (List list : CommonUtils.safeList((List)series.getValues())) {
                            Object e = list.get(0);
                            arrayList.add(new InfluxMeasurement(influxDatabase, CommonUtils.toString(e)));
                        }
                    }
                }
                arrayList.sort(DBUtils.nameComparator());
                this.setCache(arrayList);
            }
            return this.getCachedObjects();
        }

        public InfluxMeasurement getObject(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable InfluxDatabase influxDatabase, @NotNull String string) throws DBException {
            return (InfluxMeasurement)DBUtils.findObject(this.getAllObjects(dBRProgressMonitor, influxDatabase), (String)string);
        }
    }

    class RetentionPolicyCache
    extends AbstractObjectCache<InfluxDatabase, InfluxRetentionPolicy> {
        RetentionPolicyCache() {
        }

        @NotNull
        public List<InfluxRetentionPolicy> getAllObjects(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable InfluxDatabase influxDatabase) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<InfluxRetentionPolicy> arrayList = new ArrayList<InfluxRetentionPolicy>();
                InfluxDB influxDB = InfluxDatabase.this.getDataSource().getDefaultContext(true).getInfluxDB();
                QueryResult queryResult = influxDB.query(new Query("SHOW RETENTION POLICIES ON " + InfluxDatabase.this.getName(), InfluxDatabase.this.getName()));
                for (QueryResult.Result result : queryResult.getResults()) {
                    for (QueryResult.Series series : CommonUtils.safeList((List)result.getSeries())) {
                        for (List list : CommonUtils.safeList((List)series.getValues())) {
                            String string = CommonUtils.toString((Object)InfluxUtils.getResultValue(series, list, "name"));
                            String string2 = CommonUtils.toString((Object)InfluxUtils.getResultValue(series, list, "duration"));
                            String string3 = CommonUtils.toString((Object)InfluxUtils.getResultValue(series, list, "shardGroupDuration"));
                            String string4 = CommonUtils.toString((Object)InfluxUtils.getResultValue(series, list, "replicaN"));
                            boolean bl = CommonUtils.toBoolean((Object)InfluxUtils.getResultValue(series, list, "default"));
                            arrayList.add(new InfluxRetentionPolicy(influxDatabase, string, string2, string3, string4, bl));
                        }
                    }
                }
                arrayList.sort(DBUtils.nameComparator());
                this.setCache(arrayList);
            }
            return this.getCachedObjects();
        }

        public InfluxRetentionPolicy getObject(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable InfluxDatabase influxDatabase, @NotNull String string) throws DBException {
            return (InfluxRetentionPolicy)DBUtils.findObject(this.getAllObjects(dBRProgressMonitor, influxDatabase), (String)string);
        }
    }
}

