/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.model;

import com.dbeaver.ee.influxdb.InfluxUtils;
import com.dbeaver.ee.influxdb.exec.InfluxExecutionContext;
import com.dbeaver.ee.influxdb.model.InfluxDataSourceInfo;
import com.dbeaver.ee.influxdb.model.InfluxDataType;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import com.dbeaver.ee.influxdb.model.InfluxSQLDialect;
import com.dbeaver.ee.influxdb.model.InfluxStructureAssistant;
import com.dbeaver.ee.influxdb.model.InfluxUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.AbstractObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.CommonUtils;

public class InfluxDataSource
implements DBPDataSource,
DBSInstance,
SQLDataSource,
DBSObjectContainer,
DBSObject,
DBSObjectSelector,
DBPDataTypeProvider,
DBPTermProvider,
IAdaptable {
    @NotNull
    private final DBPDataSourceContainer container;
    private List<InfluxDatabase> databases;
    private String defaultDatabase;
    private InfluxDataSourceInfo info;
    @NotNull
    private InfluxExecutionContext executionContext;
    @NotNull
    private List<InfluxExecutionContext> allContexts = new ArrayList<InfluxExecutionContext>();
    private final List<InfluxDataType> dataTypes = new ArrayList<InfluxDataType>();
    private final UserCache userCache = new UserCache();

    public InfluxDataSource(DBRProgressMonitor dBRProgressMonitor, @NotNull DBPDataSourceContainer dBPDataSourceContainer) throws DBCException {
        this.container = dBPDataSourceContainer;
        InfluxDataType.TypeName[] typeNameArray = InfluxDataType.TypeName.values();
        int n = typeNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            InfluxDataType.TypeName typeName = typeNameArray[n2];
            this.dataTypes.add(new InfluxDataType(this, typeName));
            ++n2;
        }
        this.executionContext = new InfluxExecutionContext(this, "Main Influx Connection");
        this.executionContext.connect(dBRProgressMonitor);
    }

    public SQLDialect getSQLDialect() {
        return InfluxSQLDialect.INSTANCE;
    }

    @NotNull
    public DBPDataSourceContainer getContainer() {
        return this.container;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String string) {
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        this.defaultDatabase = this.getContainer().getActualConnectionConfiguration().getDatabaseName();
        this.info = new InfluxDataSourceInfo(this);
        this.databases = new ArrayList<InfluxDatabase>();
        InfluxDB influxDB = this.getDefaultContext(true).getInfluxDB();
        QueryResult queryResult = influxDB.query(new Query("SHOW DATABASES", CommonUtils.isEmpty((String)this.defaultDatabase) ? null : this.defaultDatabase));
        for (QueryResult.Result result : queryResult.getResults()) {
            List list = ((QueryResult.Series)result.getSeries().get(0)).getValues();
            for (List list2 : list) {
                Object e = list2.get(0);
                this.databases.add(new InfluxDatabase(this, CommonUtils.toString(e)));
            }
        }
        this.databases.sort(DBUtils.nameComparator());
    }

    @NotNull
    public InfluxExecutionContext getDefaultContext(boolean bl) {
        return this.executionContext;
    }

    @NotNull
    public InfluxExecutionContext[] getAllContexts() {
        return this.allContexts.toArray(new InfluxExecutionContext[this.allContexts.size()]);
    }

    @NotNull
    public InfluxExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull String string) throws DBException {
        InfluxExecutionContext influxExecutionContext = new InfluxExecutionContext(this, string);
        influxExecutionContext.connect(dBRProgressMonitor);
        return influxExecutionContext;
    }

    public void addExecutionContext(InfluxExecutionContext influxExecutionContext) {
        this.allContexts.add(influxExecutionContext);
    }

    public void removeExecutionContext(InfluxExecutionContext influxExecutionContext) {
        this.allContexts.remove((Object)influxExecutionContext);
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == DBSStructureAssistant.class) {
            return clazz.cast(new InfluxStructureAssistant(this));
        }
        return null;
    }

    public String getObjectTypeTerm(String string, String string2, boolean bl) {
        String string3 = null;
        if ("database".equals(string2)) {
            string3 = "Database";
        } else if ("measurement".equals(string2)) {
            string3 = "Measurement";
        }
        if (string3 != null && bl) {
            string3 = String.valueOf(string3) + "s";
        }
        return string3;
    }

    public DBSInstance getDefaultInstance() {
        return this;
    }

    public Collection<? extends DBSInstance> getAvailableInstances() {
        return Collections.singletonList(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(DBRProgressMonitor dBRProgressMonitor) {
        InfluxDataSource influxDataSource = this;
        synchronized (influxDataSource) {
            this.executionContext.close();
        }
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.container;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this;
    }

    @NotNull
    public String getName() {
        return this.container.getName();
    }

    public boolean isPersisted() {
        return true;
    }

    @Association
    public List<InfluxDatabase> getDatabases() {
        return this.databases;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.databases;
    }

    public InfluxDatabase getChild(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull String string) throws DBException {
        return (InfluxDatabase)DBUtils.findObject(this.databases, (String)string);
    }

    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return InfluxDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor dBRProgressMonitor, int n) throws DBException {
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    public InfluxDatabase getDefaultObject() {
        if (this.databases == null) {
            return null;
        }
        for (InfluxDatabase influxDatabase : this.databases) {
            if (this.defaultDatabase == null || !CommonUtils.equalObjects((Object)influxDatabase.getName(), (Object)this.defaultDatabase)) continue;
            return influxDatabase;
        }
        return null;
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor dBRProgressMonitor, @NotNull DBSObject dBSObject) throws DBException {
        InfluxDatabase influxDatabase = this.getDefaultObject();
        InfluxDatabase influxDatabase2 = (InfluxDatabase)dBSObject;
        this.defaultDatabase = influxDatabase2.getName();
        if (influxDatabase != null) {
            DBUtils.fireObjectSelect((DBSObject)influxDatabase, (boolean)false);
        }
        DBUtils.fireObjectSelect((DBSObject)influxDatabase2, (boolean)true);
    }

    public boolean refreshDefaultObject(@NotNull DBCSession dBCSession) throws DBException {
        return false;
    }

    public DBPDataKind resolveDataKind(String string, int n) {
        for (InfluxDataType influxDataType : this.dataTypes) {
            if (!influxDataType.getTypeName().equals(string)) continue;
            return influxDataType.getDataKind();
        }
        return null;
    }

    public InfluxDataType resolveDataType(DBRProgressMonitor dBRProgressMonitor, String string) throws DBException {
        return this.getLocalDataType(string);
    }

    public List<InfluxDataType> getLocalDataTypes() {
        return this.dataTypes;
    }

    public InfluxDataType getLocalDataType(String string) {
        for (InfluxDataType influxDataType : this.dataTypes) {
            if (!influxDataType.getTypeName().equals(string)) continue;
            return influxDataType;
        }
        return null;
    }

    public InfluxDataType getLocalDataType(int n) {
        for (InfluxDataType influxDataType : this.dataTypes) {
            if (influxDataType.getTypeID() != n) continue;
            return influxDataType;
        }
        return null;
    }

    public String getDefaultDataTypeName(DBPDataKind dBPDataKind) {
        return InfluxDataType.TypeName.STRING.getTypeName();
    }

    @Association
    public List<InfluxUser> getUsers(DBRProgressMonitor dBRProgressMonitor) throws DBException {
        return this.userCache.getAllObjects(dBRProgressMonitor, this);
    }

    class UserCache
    extends AbstractObjectCache<InfluxDataSource, InfluxUser> {
        UserCache() {
        }

        @NotNull
        public List<InfluxUser> getAllObjects(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable InfluxDataSource influxDataSource) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<InfluxUser> arrayList = new ArrayList<InfluxUser>();
                InfluxDB influxDB = influxDataSource.getDefaultContext(true).getInfluxDB();
                QueryResult queryResult = influxDB.query(new Query("SHOW USERS", null));
                for (QueryResult.Result result : queryResult.getResults()) {
                    for (QueryResult.Series series : CommonUtils.safeList((List)result.getSeries())) {
                        for (List list : CommonUtils.safeList((List)series.getValues())) {
                            String string = CommonUtils.toString((Object)InfluxUtils.getResultValue(series, list, "user"));
                            boolean bl = CommonUtils.toBoolean((Object)InfluxUtils.getResultValue(series, list, "admin"));
                            arrayList.add(new InfluxUser(influxDataSource, string, bl));
                        }
                    }
                }
                arrayList.sort(DBUtils.nameComparator());
                this.setCache(arrayList);
            }
            return this.getCachedObjects();
        }

        public InfluxUser getObject(@NotNull DBRProgressMonitor dBRProgressMonitor, @Nullable InfluxDataSource influxDataSource, @NotNull String string) throws DBException {
            return (InfluxUser)DBUtils.findObject(this.getAllObjects(dBRProgressMonitor, influxDataSource), (String)string);
        }
    }
}

