/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.data;

import com.dbeaver.ee.influxdb.exec.InfluxResultSet;
import com.dbeaver.ee.influxdb.exec.InfluxResultSetMetaColumn;
import com.dbeaver.ee.influxdb.model.InfluxDatabase;
import com.dbeaver.ee.influxdb.model.InfluxMeasurement;
import com.dbeaver.ee.influxdb.model.InfluxMeasurementField;
import com.dbeaver.ee.influxdb.model.InfluxMeasurementTag;
import com.dbeaver.ee.model.timeseries.TSDataProvider;
import com.dbeaver.ee.model.timeseries.TSMeasurement;
import com.dbeaver.ee.model.timeseries.TSPoint;
import com.dbeaver.ee.model.timeseries.TSProjection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.utils.CommonUtils;

public class InfluxTimeSeriesDataProvider
implements TSDataProvider {
    private static final Log log = Log.getLog(InfluxTimeSeriesDataProvider.class);
    private DBSDataContainer dataContainer;
    private QueryResult.Series series;
    private InfluxMeasurement measurement;
    private List<String> fieldNames;
    private Map<String, List<String>> tagValues;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public InfluxTimeSeriesDataProvider(DBSDataContainer dBSDataContainer) {
        this.dataContainer = dBSDataContainer;
    }

    public void initData(DBDAttributeBinding[] dBDAttributeBindingArray, Object[][] objectArray) throws DBException {
        if (dBDAttributeBindingArray.length == 0) {
            return;
        }
        InfluxResultSet influxResultSet = ((InfluxResultSetMetaColumn)dBDAttributeBindingArray[0].getMetaAttribute()).getResultSet();
        InfluxDatabase influxDatabase = influxResultSet.getSourceStatement().getCurrentDatabase();
        this.series = influxResultSet.getSeries();
        VoidProgressMonitor voidProgressMonitor = new VoidProgressMonitor();
        List<InfluxMeasurement> list = influxDatabase.getMeasurements((DBRProgressMonitor)voidProgressMonitor);
        String string = this.series.getName();
        if (CommonUtils.isEmpty((String)string)) {
            return;
        }
        this.measurement = (InfluxMeasurement)DBUtils.findObject(list, (String)string);
        if (this.measurement == null) {
            throw new DBException("Measurement '" + string + "' not found");
        }
        this.fieldNames = new ArrayList<String>();
        this.tagValues = new LinkedHashMap<String, List<String>>();
        for (InfluxMeasurementField object : this.measurement.getFields((DBRProgressMonitor)voidProgressMonitor)) {
            if ("time".equals(object.getName()) || object.getDataKind() != DBPDataKind.NUMERIC) continue;
            this.fieldNames.add(object.getName());
        }
        for (InfluxMeasurementTag influxMeasurementTag : this.measurement.getTags((DBRProgressMonitor)voidProgressMonitor)) {
            List<String> list2 = influxMeasurementTag.getTagValues((DBRProgressMonitor)voidProgressMonitor);
            this.tagValues.put(influxMeasurementTag.getName(), list2);
        }
    }

    public String getSeriesName() {
        return this.series == null ? null : this.series.getName();
    }

    @NotNull
    public List<TSMeasurement> getMeasurements() {
        ArrayList<TSMeasurement> arrayList = new ArrayList<TSMeasurement>();
        if (!CommonUtils.isEmpty(this.fieldNames)) {
            for (String string : this.series.getColumns()) {
                if (!this.fieldNames.contains(string)) continue;
                arrayList.add(new TSMeasurement(string));
            }
        }
        return arrayList;
    }

    @Nullable
    public List<TSProjection> getProjections(Object[][] objectArray) {
        if (this.series == null) {
            return null;
        }
        ArrayList<TSProjection> arrayList = new ArrayList<TSProjection>();
        if (CommonUtils.isEmpty((Map)this.series.getTags())) {
            for (String string : this.tagValues.keySet()) {
                List<String> list = this.tagValues.get(string);
                if (CommonUtils.isEmpty(list)) continue;
                for (String string2 : list) {
                    arrayList.add(new TSProjection(string, string2));
                }
            }
        } else {
            for (Map.Entry entry : this.series.getTags().entrySet()) {
                for (String string : this.tagValues.keySet()) {
                    List<String> list;
                    if (CommonUtils.equalObjects(entry.getKey(), (Object)string) || CommonUtils.isEmpty(list = this.tagValues.get(string))) continue;
                    for (String string3 : list) {
                        arrayList.add(new TSProjection(string, string3));
                    }
                }
            }
        }
        return arrayList;
    }

    @NotNull
    public List<TSPoint> getPoints(@NotNull TSMeasurement tSMeasurement, @Nullable TSProjection tSProjection, Object[][] objectArray) throws DBException {
        ArrayList<TSPoint> arrayList = new ArrayList<TSPoint>();
        if (this.series != null && this.series.getValues() != null) {
            int n = this.series.getColumns().indexOf("time");
            int n2 = this.series.getColumns().indexOf(tSMeasurement.getName());
            if (n < 0 || n2 < 0) {
                throw new DBException("Time and/or measure column not present in result set");
            }
            int n3 = tSProjection == null ? -1 : this.series.getColumns().indexOf(tSProjection.getName());
            Object[][] objectArray2 = objectArray;
            int n4 = objectArray.length;
            int n5 = 0;
            while (n5 < n4) {
                block10: {
                    Object[] objectArray3 = objectArray2[n5];
                    Object object = objectArray3[n];
                    if (object != null) {
                        if (!(object instanceof Date)) {
                            try {
                                object = this.formatter.parse(CommonUtils.toString((Object)object));
                            }
                            catch (ParseException parseException) {
                                log.debug((Object)"Error parsing Influx date", (Throwable)parseException);
                                break block10;
                            }
                        }
                        Number number = (Number)objectArray3[n2];
                        if (n3 < 0) {
                            arrayList.add(new TSPoint((Date)object, number));
                        } else {
                            Object object2 = objectArray3[n3];
                            if (CommonUtils.equalObjects((Object)object2, (Object)tSProjection.getValue())) {
                                arrayList.add(new TSPoint((Date)object, number));
                            }
                        }
                    }
                }
                ++n5;
            }
        }
        return arrayList;
    }
}

