/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.SQLQuery;

public class SQLQueryResult {
    private SQLQuery statement;
    private Long rowOffset;
    private boolean hasResultSet;
    private Throwable error;
    private long queryTime;
    private List<Throwable> warnings;
    private List<ExecuteResult> executeResults = new ArrayList<ExecuteResult>();

    public SQLQueryResult(@NotNull SQLQuery statement) {
        this.statement = statement;
    }

    @NotNull
    public SQLQuery getStatement() {
        return this.statement;
    }

    public Long getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(Long rowOffset) {
        this.rowOffset = rowOffset;
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    public void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
    }

    public boolean hasError() {
        return this.error != null;
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public long getQueryTime() {
        return this.queryTime;
    }

    public void setQueryTime(long queryTime) {
        this.queryTime = queryTime;
    }

    public List<Throwable> getWarnings() {
        return this.warnings;
    }

    public void addWarnings(Throwable[] warnings) {
        if (warnings == null) {
            return;
        }
        if (this.warnings == null) {
            this.warnings = new ArrayList<Throwable>();
        }
        Collections.addAll(this.warnings, warnings);
    }

    public ExecuteResult addExecuteResult(boolean resultSet) {
        ExecuteResult executeResult = new ExecuteResult(resultSet);
        this.executeResults.add(executeResult);
        return executeResult;
    }

    public List<ExecuteResult> getExecuteResults() {
        return this.executeResults;
    }

    public ExecuteResult getExecuteResults(int order, boolean resultSets) {
        int rsIndex = -1;
        int i = 0;
        while (i < this.executeResults.size()) {
            if ((!resultSets || this.executeResults.get(i).isResultSet()) && ++rsIndex == order) {
                return this.executeResults.get(i);
            }
            ++i;
        }
        return null;
    }

    public static class ExecuteResult {
        private boolean resultSet;
        private Long rowCount;
        private Long updateCount;
        private String resultSetName;

        public ExecuteResult(boolean resultSet) {
            this.resultSet = resultSet;
        }

        public boolean isResultSet() {
            return this.resultSet;
        }

        @Nullable
        public Long getRowCount() {
            return this.rowCount;
        }

        public void setRowCount(Long rowCount) {
            this.rowCount = rowCount;
        }

        @Nullable
        public Long getUpdateCount() {
            return this.updateCount;
        }

        public void setUpdateCount(Long updateCount) {
            this.updateCount = updateCount;
        }

        @Nullable
        public String getResultSetName() {
            return this.resultSetName;
        }

        public void setResultSetName(String resultSetName) {
            this.resultSetName = resultSetName;
        }
    }
}

