/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.dbeaver.debug.ui.DatabaseScriptEditor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DatabaseScriptDialog
extends TitleAreaDialog {
    private final DBSObject dbsObject;
    private String scriptValue;
    private IEditorSite subSite;
    private SQLEditorBase sqlViewer;
    private StringEditorInput sqlInput;

    public DatabaseScriptDialog(Shell shell, IWorkbenchPartSite parentSite, String name, String value, DBSObject dbsObject) {
        super(shell);
        this.dbsObject = dbsObject;
        this.subSite = new SubEditorSite(parentSite);
        this.sqlInput = new StringEditorInput(name, (CharSequence)value, true, GeneralUtils.getDefaultFileEncoding());
        this.scriptValue = value;
    }

    public String getScriptTextValue() {
        return this.scriptValue;
    }

    protected Control createDialogArea(Composite parent) {
        String title = "Specify Script";
        this.getShell().setText(title);
        Control createdArea = super.createDialogArea(parent);
        this.sqlViewer = new DatabaseScriptEditor(this.dbsObject, title);
        try {
            this.sqlViewer.init(this.subSite, (IEditorInput)this.sqlInput);
            this.sqlViewer.reloadSyntaxRules();
            Object text = this.sqlViewer.getAdapter(Control.class);
            if (text instanceof StyledText) {
                ((StyledText)text).setEditable(true);
            }
        }
        catch (PartInitException e) {
            DBUserInterface.getInstance().showError(this.getShell().getText(), null, (Throwable)e);
        }
        Composite panel = UIUtils.createPlaceholder((Composite)parent, (int)1);
        panel.setLayoutData((Object)new GridData(1808));
        Composite editorPH = new Composite(panel, 2048);
        GridData gd = new GridData(1808);
        gd.verticalIndent = 3;
        gd.horizontalSpan = 1;
        gd.minimumHeight = 100;
        gd.minimumWidth = 100;
        editorPH.setLayoutData((Object)gd);
        editorPH.setLayout((Layout)new FillLayout());
        this.sqlViewer.createPartControl(editorPH);
        return createdArea;
    }

    protected void okPressed() {
        this.scriptValue = this.sqlViewer.getDocument().get();
        super.okPressed();
    }
}

