/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class BaseURI
extends OXMLFunction {
    private int numParams;

    BaseURI(int n) {
        this.numParams = n;
    }

    @Override
    public String getFunctionName() {
        return "base-uri";
    }

    @Override
    public int getNumberArgs() {
        return this.numParams;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.getConstantType(2, 17);
    }

    @Override
    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.NODE_ZERO_OR_ONE;
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext) throws XQException {
        OXMLItem oXMLItem = oXMLFunctionContext.getContextItem();
        if (oXMLItem == null) {
            throw new XQException("FONC0001");
        }
        if (!FNUtil.isNode(oXMLItem)) {
            throw new XQException("XPTY0004");
        }
        String string = this.getBaseURI(oXMLFunctionContext.getBaseURI(), oXMLItem.getNode());
        OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
        if (string != null) {
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setString(OXMLSequenceType.TANYURI, string);
            oXMLSequence.appendItem(oXMLItem2);
        }
        return oXMLSequence;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            return oXMLSequence2;
        }
        String string = this.getBaseURI(oXMLFunctionContext.getBaseURI(), oXMLItem.getNode());
        if (string != null) {
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setString(OXMLSequenceType.TANYURI, string);
            oXMLSequence2.appendItem(oXMLItem2);
        }
        return oXMLSequence2;
    }

    private String getBaseURI(String string, XMLNode xMLNode) {
        XMLDocument xMLDocument;
        String string2 = xMLNode.getBaseURI();
        if (string2 == null && (xMLDocument = (XMLDocument)xMLNode.getOwnerDocument()) != null) {
            string2 = xMLDocument.getBaseURI();
        }
        return string2;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray == null) {
            return this.invoke(oXMLFunctionContext);
        }
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence = oXMLSequenceArray.length == 0 ? this.invoke(oXMLFunctionContext) : this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
        return oXMLSequence;
    }
}

