/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.schema.XSDCharClass;
import oracle.xml.parser.schema.XSDException;

public class XSDRegexProgram {
    char[] instruction;
    private int lenInstruction;
    private int flags;
    char[] allChars = null;
    int charLen;
    XSDCharClass[] chClass = null;
    boolean hasWildcard = false;

    public XSDRegexProgram(char[] cArray) {
        this(cArray, cArray.length);
    }

    public XSDRegexProgram(char[] cArray, int n) {
        this.setInstructions(cArray, n);
    }

    XSDRegexProgram(char[] cArray, int n, XSDCharClass[] xSDCharClassArray) {
        this(cArray, n);
        this.chClass = xSDCharClassArray;
    }

    void checkChar(char c) throws XSDException {
        int n;
        if (this.hasWildcard) {
            return;
        }
        if (this.allChars != null) {
            for (n = 0; n < this.charLen; ++n) {
                if (c != this.allChars[n]) continue;
                return;
            }
        }
        if (this.chClass != null) {
            for (n = 0; n < this.chClass.length; ++n) {
                if (this.chClass[n] == null || !this.chClass[n].match(c)) continue;
                return;
            }
        }
        throw new XSDException(24501, "invalid character");
    }

    public char[] getInstructions() {
        if (this.lenInstruction != 0) {
            char[] cArray = new char[this.lenInstruction];
            System.arraycopy(this.instruction, 0, cArray, 0, this.lenInstruction);
            return cArray;
        }
        return null;
    }

    public void setInstructions(char[] cArray, int n) {
        this.instruction = cArray;
        this.lenInstruction = n;
        this.flags = 0;
        if (cArray != null && n != 0) {
            int n2;
            if (n >= 3 && cArray[0] == '|' && cArray[n2 = cArray[2]] == 'E' && n >= 6 && cArray[3] == 'A') {
                char c = cArray[4];
                char[] cArray2 = new char[c];
                System.arraycopy(cArray, 6, cArray2, 0, c);
            }
            block5: for (n2 = 0; n2 < n; n2 += 3) {
                switch (cArray[n2]) {
                    case '[': {
                        n2 += cArray[n2 + 1] * 2;
                        continue block5;
                    }
                    case 'A': {
                        n2 += cArray[n2 + 1];
                        continue block5;
                    }
                    case '#': {
                        this.flags |= 1;
                        return;
                    }
                }
            }
        }
    }
}

