/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools.maintenance;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.sql.GenerateMultiSQLDialog;
import org.jkiss.dbeaver.ui.dialogs.sql.SQLScriptProgressListener;
import org.jkiss.dbeaver.ui.dialogs.sql.SQLScriptStatusDialog;

public abstract class TableToolDialog
extends GenerateMultiSQLDialog<PostgreObject> {
    private Button separateTransactionCheck;
    private boolean runInSeparateTransaction = false;

    public TableToolDialog(IWorkbenchPartSite partSite, String title, Collection<? extends PostgreTableBase> tables) {
        super(partSite, title, TableToolDialog.toObjects(tables), true);
    }

    public TableToolDialog(IWorkbenchPartSite partSite, String title, PostgreDatabase database) {
        super(partSite, title, Collections.singletonList(database), true);
    }

    private static Collection<PostgreObject> toObjects(Collection<? extends PostgreTableBase> tables) {
        ArrayList<PostgreObject> objectList = new ArrayList<PostgreObject>();
        objectList.addAll(tables);
        return objectList;
    }

    protected SQLScriptProgressListener<PostgreObject> getScriptListener() {
        return new SQLScriptStatusDialog<PostgreObject>(String.valueOf(this.getTitle()) + " progress", null){

            protected void createStatusColumns(Tree objectTree) {
                TreeColumn msgColumn = new TreeColumn(objectTree, 0);
                msgColumn.setText("Message");
            }

            public void processObjectResults(@NotNull PostgreObject object, @Nullable DBCStatement statement, @Nullable DBCResultSet resultSet) throws DBCException {
                if (statement == null) {
                    return;
                }
                TreeItem treeItem = this.getTreeItem(object);
                if (treeItem != null) {
                    try {
                        int warnNum = 0;
                        SQLWarning warning = ((JDBCStatement)statement).getWarnings();
                        while (warning != null) {
                            if (warnNum == 0) {
                                treeItem.setText(1, warning.getMessage());
                            } else {
                                TreeItem warnItem = new TreeItem(treeItem, 0);
                                warnItem.setText(0, "");
                                warnItem.setText(1, warning.getMessage());
                            }
                            ++warnNum;
                            warning = warning.getNextWarning();
                        }
                        if (warnNum == 0) {
                            treeItem.setText(1, "Done");
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    treeItem.setExpanded(true);
                }
            }

            public void endObjectProcessing(@NotNull PostgreObject object, Exception error) {
                TreeItem treeItem;
                super.endObjectProcessing((DBSObject)object, error);
                if (error != null && (treeItem = this.getTreeItem(object)) != null) {
                    treeItem.setText(1, error.getMessage());
                }
            }
        };
    }

    protected void createTransactionCheck(Group optionsGroup) {
        this.runInSeparateTransaction = true;
        this.separateTransactionCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)PostgreMessages.tool_run_in_separate_transaction, (String)PostgreMessages.tool_run_in_separate_transaction_tooltip, (boolean)this.runInSeparateTransaction, (int)0);
        this.separateTransactionCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableToolDialog.this.runInSeparateTransaction = TableToolDialog.this.separateTransactionCheck.getSelection();
            }
        });
    }

    protected boolean isRunInSeparateTransaction() {
        return this.runInSeparateTransaction;
    }
}

