/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollection;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCArrayValueHandler;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class PostgreArrayValueHandler
extends JDBCArrayValueHandler {
    public static final PostgreArrayValueHandler INSTANCE = new PostgreArrayValueHandler();

    public DBDCollection getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object != null) {
            String className = object.getClass().getName();
            if (object instanceof String || className.equals("org.postgresql.util.PGobject")) {
                PostgreDataType itemType = null;
                PostgreDataType arrayType = PostgreUtils.findDataType((PostgreDataSource)session.getDataSource(), type);
                if (arrayType != null) {
                    itemType = arrayType.getElementType(session.getProgressMonitor());
                }
                if (itemType != null) {
                    if (className.equals("org.postgresql.util.PGobject")) {
                        Object value = PostgreUtils.extractPGObjectValue(object);
                        if (value == null) {
                            return null;
                        }
                        if (value instanceof String) {
                            return this.convertStringToArray(session, itemType, (String)value);
                        }
                        return new JDBCCollection((DBSDataType)itemType, DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType), new Object[]{value});
                    }
                    if (object instanceof String) {
                        return this.convertStringToArray(session, itemType, (String)object);
                    }
                }
            }
        }
        return super.getValueFromObject(session, type, object, copy);
    }

    private JDBCCollection convertStringToArray(@NotNull DBCSession session, @NotNull PostgreDataType itemType, @NotNull String value) {
        ArrayList<String> strings = new ArrayList<String>(10);
        StringTokenizer st = new StringTokenizer(value, " ");
        while (st.hasMoreTokens()) {
            strings.add(st.nextToken());
        }
        Object[] contents = new Object[strings.size()];
        int i = 0;
        while (i < strings.size()) {
            contents[i] = PostgreUtils.convertStringToValue((DBSTypedObject)itemType, (String)strings.get(i), false);
            ++i;
        }
        return new JDBCCollection((DBSDataType)itemType, DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType), contents);
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        DBDCollection collection = (DBDCollection)value;
        if (!DBUtils.isNullValue((Object)value)) {
            DBDValueHandler valueHandler = collection.getComponentValueHandler();
            StringBuilder str = new StringBuilder();
            if (format == DBDDisplayFormat.NATIVE) {
                str.append("'");
            }
            str.append("{");
            int i = 0;
            while (i < collection.getItemCount()) {
                Object item;
                if (i > 0) {
                    str.append(',');
                }
                String itemString = (item = collection.getItem(i)) instanceof JDBCCollection ? this.getValueDisplayString(column, item, format) : valueHandler.getValueDisplayString((DBSTypedObject)collection.getComponentType(), item, DBDDisplayFormat.NATIVE);
                if (format == DBDDisplayFormat.NATIVE) {
                    str.append(SQLUtils.escapeString((DBPDataSource)collection.getComponentType().getDataSource(), (String)itemString));
                } else {
                    str.append(itemString);
                }
                ++i;
            }
            str.append("}");
            if (format == DBDDisplayFormat.NATIVE) {
                str.append("'");
            }
            return str.toString();
        }
        return super.getValueDisplayString(column, value, format);
    }
}

