/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreExtension
implements PostgreObject,
PostgreScriptObject {
    private PostgreSchema schema;
    private long oid;
    private String name;
    private String version;

    public PostgreExtension(PostgreSchema schema, ResultSet dbResult) throws SQLException {
        this.schema = schema;
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"extname");
        this.version = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"extversion");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public PostgreSchema getSchema() {
        return this.schema;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=4)
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.schema;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.schema.getDataSource();
    }

    public boolean isPersisted() {
        return true;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.schema.getDatabase();
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return "-- Extension: " + this.getName() + "\n\n" + "-- DROP EXTENSION " + this.getName() + ";\n\n" + "CREATE EXTENSION " + this.getName() + "\n\t" + "SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)this.getSchema()) + "\n\t" + "VERSION " + this.version;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
    }
}

