/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableManagerBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignServer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableInheritance;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreTableManager
extends PostgreTableManagerBase
implements DBEObjectRenamer<PostgreTableBase> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{PostgreTableColumn.class, PostgreTableConstraint.class, PostgreTableForeignKey.class, PostgreIndex.class};

    @Nullable
    public DBSObjectCache<PostgreSchema, PostgreTableBase> getObjectsCache(PostgreTableBase object) {
        return ((PostgreSchema)object.getContainer()).tableCache;
    }

    protected String getCreateTableType(PostgreTableBase table) {
        if (table instanceof PostgreTableForeign) {
            return "FOREIGN TABLE";
        }
        return "TABLE";
    }

    protected PostgreTable createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, PostgreSchema parent, Object copyFrom) {
        PostgreTableRegular table = new PostgreTableRegular(parent);
        try {
            this.setTableName(monitor, (DBSObjectContainer)parent, table);
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return table;
    }

    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        String tableDDL;
        PostgreTableBase tableBase = (PostgreTableBase)command.getObject();
        if (tableBase.isPersisted() && (tableDDL = ((PostgreDataSource)tableBase.getDataSource()).getServerType().readTableDDL(monitor, tableBase)) != null) {
            actions.add(0, (DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_table, tableDDL));
            return;
        }
        super.addStructObjectCreateActions(monitor, actions, command, options);
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if ((command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) && command.getObject() instanceof PostgreTableRegular) {
            try {
                this.generateAlterActions(monitor, actionList, command);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    private void generateAlterActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command) throws DBException {
        PostgreTableRegular table = (PostgreTableRegular)command.getObject();
        String alterPrefix = "ALTER TABLE " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " ";
        if (command.hasProperty((Object)"hasOids")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(String.valueOf(alterPrefix) + (table.isHasOids() ? "SET WITH OIDS" : "SET WITHOUT OIDS")));
        }
        if (command.hasProperty((Object)"tablespace")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(String.valueOf(alterPrefix) + "SET TABLESPACE " + table.getTablespace(monitor).getName()));
        }
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, PostgreTableBase tableBase, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
        PostgreTable table;
        if (tableBase instanceof PostgreTable) {
            table = (PostgreTable)tableBase;
            if (!alter) {
                try {
                    List<PostgreTableInheritance> superTables = table.getSuperInheritance(monitor);
                    if (!CommonUtils.isEmpty(superTables)) {
                        ddl.append("\nINHERITS (");
                        int i = 0;
                        while (i < superTables.size()) {
                            if (i > 0) {
                                ddl.append(",");
                            }
                            ddl.append(superTables.get(i).getAssociatedEntity().getFullyQualifiedName(DBPEvaluationContext.DDL));
                            ++i;
                        }
                        ddl.append(")");
                    }
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
        }
        if (tableBase instanceof PostgreTableRegular) {
            table = (PostgreTableRegular)tableBase;
            try {
                if (!alter && ((PostgreDataSource)table.getDataSource()).getServerType().supportsOids() && table.isHasOids()) {
                    ddl.append("\nWITH (\n\tOIDS=").append(table.isHasOids() ? "TRUE" : "FALSE");
                    ddl.append("\n)");
                }
                boolean hasOtherSpecs = false;
                PostgreTablespace tablespace = table.getTablespace(monitor);
                if (tablespace != null && table.isTablespaceSpecified()) {
                    if (!alter) {
                        ddl.append("\nTABLESPACE ").append(tablespace.getName());
                    }
                    hasOtherSpecs = true;
                }
                if (!alter && hasOtherSpecs) {
                    ddl.append("\n");
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        } else if (tableBase instanceof PostgreTableForeign) {
            table = (PostgreTableForeign)tableBase;
            try {
                Object[] foreignOptions;
                PostgreForeignServer foreignServer = ((PostgreTableForeign)table).getForeignServer(monitor);
                if (foreignServer != null) {
                    ddl.append("\nSERVER ").append(DBUtils.getQuotedIdentifier((DBSObject)foreignServer));
                }
                if (!ArrayUtils.isEmpty((Object[])(foreignOptions = ((PostgreTableForeign)table).getForeignOptions(monitor)))) {
                    ddl.append("\nOPTIONS ").append(PostgreUtils.getOptionsString((String[])foreignOptions));
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        tableBase.appendTableModifiers(monitor, ddl);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "ALTER TABLE " + DBUtils.getQuotedIdentifier((DBSObject)((PostgreTableBase)command.getObject()).getSchema()) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreTableBase)command.getObject()).getDataSource(), (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreTableBase)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public void renameObject(DBECommandContext commandContext, PostgreTableBase object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, "DROP " + (command.getObject() instanceof PostgreTableForeign ? "FOREIGN TABLE" : "TABLE") + " " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + (CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE" : "")));
    }
}

