/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ContentSummary
extends QuotaUsage
implements Writable {
    private long length;
    private long fileCount;
    private long directoryCount;
    private static final String SUMMARY_FORMAT = "%12s %12s %18s ";
    private static final String[] SUMMARY_HEADER_FIELDS = new String[]{"DIR_COUNT", "FILE_COUNT", "CONTENT_SIZE"};
    private static final String SUMMARY_HEADER = String.format("%12s %12s %18s ", SUMMARY_HEADER_FIELDS);
    private static final String ALL_HEADER = QUOTA_HEADER + SUMMARY_HEADER;

    @Deprecated
    public ContentSummary() {
    }

    @Deprecated
    public ContentSummary(long length, long fileCount, long directoryCount) {
        this(length, fileCount, directoryCount, -1L, length, -1L);
    }

    @Deprecated
    public ContentSummary(long length, long fileCount, long directoryCount, long quota, long spaceConsumed, long spaceQuota) {
        this.length = length;
        this.fileCount = fileCount;
        this.directoryCount = directoryCount;
        this.setQuota(quota);
        this.setSpaceConsumed(spaceConsumed);
        this.setSpaceQuota(spaceQuota);
    }

    private ContentSummary(Builder builder) {
        super(builder);
        this.length = builder.length;
        this.fileCount = builder.fileCount;
        this.directoryCount = builder.directoryCount;
    }

    public long getLength() {
        return this.length;
    }

    public long getDirectoryCount() {
        return this.directoryCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    @Override
    @InterfaceAudience.Private
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.length);
        out.writeLong(this.fileCount);
        out.writeLong(this.directoryCount);
        out.writeLong(this.getQuota());
        out.writeLong(this.getSpaceConsumed());
        out.writeLong(this.getSpaceQuota());
    }

    @Override
    @InterfaceAudience.Private
    public void readFields(DataInput in) throws IOException {
        this.length = in.readLong();
        this.fileCount = in.readLong();
        this.directoryCount = in.readLong();
        this.setQuota(in.readLong());
        this.setSpaceConsumed(in.readLong());
        this.setSpaceQuota(in.readLong());
    }

    @Override
    public boolean equals(Object to) {
        if (this == to) {
            return true;
        }
        if (to instanceof ContentSummary) {
            return this.getLength() == ((ContentSummary)to).getLength() && this.getFileCount() == ((ContentSummary)to).getFileCount() && this.getDirectoryCount() == ((ContentSummary)to).getDirectoryCount() && super.equals(to);
        }
        return super.equals(to);
    }

    @Override
    public int hashCode() {
        long result = this.getLength() ^ this.getFileCount() ^ this.getDirectoryCount();
        return (int)result ^ super.hashCode();
    }

    public static String getHeader(boolean qOption) {
        return qOption ? ALL_HEADER : SUMMARY_HEADER;
    }

    public static String[] getHeaderFields() {
        return SUMMARY_HEADER_FIELDS;
    }

    public static String[] getQuotaHeaderFields() {
        return QUOTA_HEADER_FIELDS;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean qOption) {
        return this.toString(qOption, false);
    }

    public String toString(boolean qOption, boolean hOption) {
        return this.toString(qOption, hOption, false, null);
    }

    public String toString(boolean qOption, boolean hOption, boolean tOption, List<StorageType> types) {
        String prefix = "";
        if (tOption) {
            return this.getTypesQuotaUsage(hOption, types);
        }
        if (qOption) {
            prefix = this.getQuotaUsage(hOption);
        }
        return prefix + String.format(SUMMARY_FORMAT, this.formatSize(this.directoryCount, hOption), this.formatSize(this.fileCount, hOption), this.formatSize(this.length, hOption));
    }

    private String formatSize(long size, boolean humanReadable) {
        return humanReadable ? StringUtils.TraditionalBinaryPrefix.long2String(size, "", 1) : String.valueOf(size);
    }

    public static class Builder
    extends QuotaUsage.Builder {
        private long length;
        private long fileCount;
        private long directoryCount;

        public Builder length(long length) {
            this.length = length;
            return this;
        }

        public Builder fileCount(long fileCount) {
            this.fileCount = fileCount;
            return this;
        }

        public Builder directoryCount(long directoryCount) {
            this.directoryCount = directoryCount;
            return this;
        }

        @Override
        public Builder quota(long quota) {
            super.quota(quota);
            return this;
        }

        @Override
        public Builder spaceConsumed(long spaceConsumed) {
            super.spaceConsumed(spaceConsumed);
            return this;
        }

        @Override
        public Builder spaceQuota(long spaceQuota) {
            super.spaceQuota(spaceQuota);
            return this;
        }

        @Override
        public Builder typeConsumed(long[] typeConsumed) {
            super.typeConsumed(typeConsumed);
            return this;
        }

        @Override
        public Builder typeQuota(StorageType type, long quota) {
            super.typeQuota(type, quota);
            return this;
        }

        @Override
        public Builder typeConsumed(StorageType type, long consumed) {
            super.typeConsumed(type, consumed);
            return this;
        }

        @Override
        public Builder typeQuota(long[] typeQuota) {
            super.typeQuota(typeQuota);
            return this;
        }

        @Override
        public ContentSummary build() {
            super.fileAndDirectoryCount(this.fileCount + this.directoryCount);
            return new ContentSummary(this);
        }
    }
}

